/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a system file tree. See {@link Ametys.file.AbstractFileExplorerTree}
 * @private
 */
Ext.define('Ametys.file.AbstractFileExplorerTree.FileNode', { 
    extend: 'Ext.data.Model',

    fields: [
        {name: 'type', defaultValue: "resource"},
        {name: 'text', mapping: 'name', type: 'string'},
        {name: 'name'},
        {name: 'path'},
        {name: 'lastModified'},
        {name: 'size'},
        {name: 'mimetype'},
        {
            name: 'leaf', 
            type: 'boolean', 
            calculate: function(data) {
                return data.type == 'resource';
            }
        },
        {
            name: 'iconCls',
            depends: ['type', 'name'],
            calculate: function(data)
            {
                if (data.type == 'collection')
                {
                    return "ametysicon-folder249";
                }
                else
                {
                    return Ametys.file.AbstractFileExplorerTree.getFileIconGlyph(data.name);
                }
            }
        }
    ]
});
