/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Display value for "enumerated" boolean
 */
Ext.define('Ametys.form.widget.BooleanComboTextComparison', {
    extend: "Ametys.form.widget.ComboTextComparison",
    
    constructor: function (config)
    {
        config.enumeration = [
           ['', config.emptyLabel || "{{i18n PLUGINS_CORE_UI_WIDGET_BOOLEAN_COMBOBOX_DEFAULT_EMPTY_LABEL}}"],
           ['true', config.trueLabel || "{{i18n PLUGINS_CORE_UI_WIDGET_BOOLEAN_COMBOBOX_DEFAULT_TRUE_LABEL}}"],
           ['false', config.falseLabel || "{{i18n PLUGINS_CORE_UI_WIDGET_BOOLEAN_COMBOBOX_DEFAULT_FALSE_LABEL}}"]
        ];
        config.value = config.value === undefined ? '' : config.value;  
        
        this.callParent(arguments);
    }
});