/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Provides a widget for text field<br>
 * This widget is the default widget registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 * It does handle multiple values (see {@link #cfg-multiple}) using separated by commas text. 
 */
Ext.define('Ametys.form.widget.ComboTextComparison', {
    extend: "Ametys.form.widget.TextComparison",
    
    setValue: function(value)
    {
        this._rawValue = value;
                
        let comparison;
        
        if (this._baseValue !== undefined || this._futureValue !== undefined)
        {
            let base = this._baseValue !== undefined;
            
            comparison = Ametys.form.widget.Comparison.compareCanonicalValues(value, base ? this._baseValue : this._futureValue, base);
        }
        
        if (Ext.isArray(value))
        {
            let convertedValues = value.map((v,i) => this._convertToDisplayableValue(v, comparison && comparison.length > i ? comparison[i] : null));
            Ametys.form.widget.TextComparison.superclass.setValue.apply(this, [convertedValues.join(', ')]); 
        }
        else
        {
            Ametys.form.widget.TextComparison.superclass.setValue.apply(this, [this._convertToDisplayableValue(value, comparison && comparison.length >= 0 ? comparison[0] : null)]);
        }
    },
    
    _convertToDisplayableValue: function(v, comparison)
    {
        let data = this.getInitialConfig("enumeration");
        for (let d of data)
        {
            if (d[0] == v)
            {
                return this._wrap(this._encodeValue(d[1]), comparison);
            }
        }
        return this._wrap(this._encodeValue(v), comparison);
    },
    
    _wrap: function(value, comparison)
    {
        if (!comparison)
        {
            return value;
        }
        else
        {
            switch (comparison)
                {
                    case "added": return "<ins class='diffins'>" + value + "</ins>";
                    case "moved": return "<span class='diffmod'>" + value + "</span>";
                    case "deleted": return "<del class='diffdel'>" + value + "</del>";
                    default:
                    case "none": return value;
                }
        }
    }
});