/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Provides a widget for text field<br>
 * This widget is the default widget registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 * It does handle multiple values (see {@link #cfg-multiple}) using separated by commas text. 
 */
Ext.define('Ametys.form.widget.FullTextAreaComparison', {
    extend: "Ametys.form.widget.TextComparison",
    
    constructor: function (config)
    {
        var height = config.height;
        
        config = Ext.apply(config, {
            height: height ? Number(height) : Ametys.form.widget.TextArea.FIELD_HEIGHT
        });
        
        this.callParent(arguments);
    },
    
    _encodeValue: function(v)
    {
        if (Array.isArray(v))
        {
            var encodedValue = [];
            for (var i = 0; i < v.length; i++)
            {
                encodedValue.push(this._escapeValue(v[i]));
            }
            return encodedValue.join("<br/>");
        }
        else
        {
            return this._escapeValue(v);
        }
    },
    
    setValue: function(values)
    {
        this._rawValue = values;
        
        values = Ext.Array.from(values);

        if (this._baseValue !== undefined || this._futureValue !== undefined)
        {
            let toDisplayValues = [];
            
            var base = this._baseValue !== undefined;
            
            var comparison = Ametys.form.widget.Comparison.compareCanonicalValues(values, base ? this._baseValue : this._futureValue, base);
            for (var c = 1; c <= comparison.length; c++)
            {
                switch (comparison[c-1])
                {
                    case "added": toDisplayValues.push("<ins class='diffins'>" + this._escapeValue(values[c-1]) + "</ins>"); break;
                    case "moved": toDisplayValues.push("<span class='diffmod'>" + this._escapeValue(values[c-1]) + "</span>"); break;
                    case "deleted": toDisplayValues.push("<del class='diffdel'>" + this._escapeValue(values[c-1]) + "</del>"); break;
                    default:
                    case "none": toDisplayValues.push(this._escapeValue(values[c-1])); break;
                }
            }
            
            Ametys.form.widget.FullTextAreaComparison.superclass.superclass.setValue.apply(this, [toDisplayValues.join("<br/>")])
        }
        else
        {
            Ametys.form.widget.FullTextAreaComparison.superclass.superclass.setValue.apply(this, [this._encodeValue(values)]);
        }
    },    
});
