/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Provides a widget for text field<br>
 * This widget is the default widget registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 * It does handle multiple values (see {@link #cfg-multiple}) using separated by commas text. 
 */
Ext.define('Ametys.form.widget.FullTextComparison', {
    extend: "Ametys.form.widget.TextComparison",
    
    /**
     * @private
     * Compare values to know if diffrents
     * @param {Object} v1 First value to compare
     * @param {Object} v2 Second value to compare
     * @return {Boolean} true if v1 is different from v2
     */
    _areDifferent: function(v1, v2)
    {
        return v1 != v2;
    },
    
    setValue: function(value)
    {
        this._rawValue = value;
        
        var toDisplayValue = this._encodeValue(value);
        
        if (this._baseValue !== undefined)
        {
            if (this._areDifferent(value, this._baseValue))
            {
                toDisplayValue = "<ins class='diffmod'>" + toDisplayValue + "</ins>";
            }
        }
        else if (this._futureValue !== undefined)
        {
            if (this._areDifferent(value, this._futureValue))
            {
                toDisplayValue = "<del class='diffmod'>" + toDisplayValue + "</del>";
            }
        }
        
        Ametys.form.widget.TextComparison.superclass.setValue.apply(this, [toDisplayValue]);
    },
});
