/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This singleton the object class associated to the glyph source type 'backoffice' in {@link Ametys.form.widget.Illustration} widget.
 * It is used to pick up a glyph for CSS files of the back office.
 * See {@link Ametys.form.widget.Illustration} widget.
 */ 
Ext.define('Ametys.form.widget.Illustration.ApplicationGlyph', {
	extend: 'Ametys.form.widget.Illustration.GlyphSource',
	
	statics: {
		
		/**
		 * @property {String} SOURCE The glyph source which belongs to this class
		 * @static
		 * @readonly
		 */
		SOURCE: 'backoffice',
		
        /**
         * @property {String} buttonText The text of button to select glyph
         * @static
         * @readonly
         */
		buttonText: "",
        
        /**
         * @property {String} buttonTooltip The tooltip of button to select glyph
         * @static
         * @readonly
         */
		buttonTooltip: "{{i18n PLUGINS_CORE_UI_WIDGET_ILLUSTRATION_SELECT_GLYPH_BUTTON}}",
        
        /**
         * @property {String} buttonIconCls The button's icon to select glyph
         * @static
         * @readonly
         */
		buttonIconCls: 'ametysicon-puzzle33',
		
        /**
         * @property {String} menuItemText The text of menu item to select glyph
         * @static
         * @readonly
         */
		menuItemText: "{{i18n PLUGINS_CORE_UI_WIDGET_ILLUSTRATION_GLYPH_MENU_ITEM_TEXT}}",
        
        /**
         * @property {String} menuItemIconCls The menu item's icon to select glyph
         * @static
         * @readonly
         */
		menuItemIconCls: 'ametysicon-puzzle33'
	},
    
    getId: function()
    {
        return Ametys.form.widget.Illustration.ApplicationGlyph.SOURCE;
    },
	
	getBtnConfig: function (config)
	{
		return {
            text: config.buttonText || this.self.buttonText,
            tooltip: config.buttonTooltip || this.self.buttonTooltip, 
            iconCls: this.self.buttonIconCls,
            source: this.self.SOURCE
        };
	},
	
	getMenuItemConfig: function (config)
	{
		return {
			text: this.self.menuItemText,
	   		iconCls: this.self.menuItemIconCls,
	   		source: this.self.SOURCE
		};
	},
	
	getCSSFiles: function (callback)
	{
        var cssFiles = {};
        cssFiles.cssFiles = {};
        Ext.bind(callback, cssFiles);
	},
    
    isAvailable: function(callback)
    {
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.plugins.core.ui.glyph.ApplicationGlyphManager",
            methodName: "hasGlyphs",
            callback: {
                scope: this,
                handler: callback,
                ignoreOnError: true
            },
            waitMessage: false,
            errorMessage: true 
        }); 
    },
	
	/**
     * Opens a dialog for choose a glyph
     */
	handler: function (config, callback)
    {
		Ametys.helper.ChooseApplicationGlyph.open({
			iconCls: config.buttonIconCls || this.self.buttonIconCls,
			title: config.dialogTitle || this.self.dialogTitle,
			helpMessage: config.dialogHint,
			callback: callback
		});
    }
});

Ametys.form.widget.Illustration.registerGlyphSource (Ametys.form.widget.Illustration.ApplicationGlyph.SOURCE, Ext.create('Ametys.form.widget.Illustration.ApplicationGlyph', {}));
