/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 /**
 * This class provides a widget to query and select one or more rights.
 * 
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 */
Ext.define('Ametys.form.widget.Right', {
    extend: 'Ametys.form.AbstractQueryableComboBox',
    
    statics: 
    {
        /**
         * @readonly
         * @property {String} READER_RIGHT id of the fake reader right
         */
        READER_RIGHT: "READER"
    },
    
    /**
     * @cfg {boolean} [includeReader] Indicate if the list of right should include a entry for the reader right
     */
    
    /**
     * @private
     * @property {Ext.data.Store} _store The store of the combobox
     */
    
    getStore: function()
    {
        var extra = {};
        if (this.getInitialConfig('includeReader') == true)
        {
            extra.includeReader = true;
        }
        
        this._store = Ext.create('Ext.data.Store', {
            autoDestroy: true,
            proxy: {
                type: 'ametys',
                plugin: 'core',
                url: 'rights/rights.json',
                extraParams: extra,
                reader: {
                    type: 'json',
                    rootProperty: 'rights'
                }
             },
             sorters: [
                 {property: 'category', direction: 'ASC'}, // sort first on category to allow "grouping"
                 {property: 'label', direction: 'ASC'}
             ],
             fields: [
	             {name: 'id'},
	             {name: 'label', type: 'string'},
	             {name: 'category', type: 'string'}
             ]
        });
        
        return this._store;
    },
    
    /**
     * Get the store of the combobox
     * @returns {Ext.data.Store} the current store of the widget
     */
    getRightStore: function()
    {
        return this._store;
    },
    
    getComboBoxConfig: function ()
    {
        var tpl = new Ext.create('Ext.XTemplate',
            '{% this.currentGroup = null; %}',
            '<div class="x-list-plain rights-list">',
            '<tpl for=".">',
            '<tpl for="category" if="this.shouldShowHeader(category)"><div class="rights-category">{[this.showHeader(values.category)]}</div></tpl>',
            '<div class="x-boundlist-item rights-item">{label}</div>',
            '</tpl>',
            '</div>',
            
            {
                shouldShowHeader: function (group) {
                    return this.currentGroup !== group;
                },
                showHeader: function (group) {
                    this.currentGroup = group;
                    return group;
                }
            }
        );
        
        var cfg = this.callParent(arguments);
        cfg.tpl = tpl;
        return cfg;
    }

});