/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Provides a widget for textarea field<br>
 * This widget is the default widget registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 * It does handle multiple values (see {@link #cfg-multiple}) using separated by commas text. 
 */
Ext.define('Ametys.form.widget.TextAreaComparison', {
    extend: "Ametys.form.widget.TextComparison",
    
    constructor: function (config)
    {
        config.cls = 'ametys-field-textarea-comparison' + (config.cls ? ' ' + config.cls : '');
        
        var height = config.height;
        
        config = Ext.apply(config, {
            height: height ? Number(height) : Ametys.form.widget.TextArea.FIELD_HEIGHT
        });
        
        this.callParent(arguments);
    },
    
    _escapeValue:function(v)
    {
        return this.callParent(arguments).replace(/\r?\n/g, '<br/>');
    }
});