/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


/**
 * Provides a widget for text field<br>
 * This widget is the default widget registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.<br>
 * It does handle multiple values (see {@link #cfg-multiple}) using separated by commas text. 
 */
Ext.define('Ametys.form.widget.UrlReferenceTextComparison', {
    extend: "Ametys.form.widget.FullTextComparison",
    
    _areDifferent: function(v1, v2)
    {
        if (v1 == v2)
        {
            return false;
        }
        if (v1 == null || v2 == null)
        {
            return true;
        }
        return v1.type != v2.type || v1.value != v2.value;
    },
    
    _escapeValue: function(v)
    {
        return v ? v.value : '';
    }
});