/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class handles the access and edition for users
 */
Ext.define( "Ametys.helper.Users", {
    singleton: true,

    /**
     * Helper function to render the name of a user.
     * @param {String} login The login of the user
     * @param {String} populationLabel The label of the population of the user
     * @param {String} [username] The full name of the user.
     * @return {String} A string representation of the user.
     */
    renderUser: function(login, populationLabel, username)
    {
        return (Ext.String.escapeHtml(username) || "{{i18n plugin.core:PLUGINS_CORE_USERS_UNKNOWN_USER}}") 
            + (login ? ' (' + login + ', ' + populationLabel + ')' : '');
    },

    /**
     * Helper to get the url of the user icon
     * @param {String} login The login of the user
     * @param {String} populationId The population id of the user
     * @param {Number} size The size of the icon
     */
    getUserImage: function(login, populationId, size)
    {
        if (login != null && populationId != null)
        {
            return Ametys.getPluginDirectPrefix('core-ui') + '/user/' + populationId + '/' + encodeURIComponent(login) + '/image_' + size;
        }
        else
        {
            return Ametys.getPluginDirectPrefix('core-ui') + '/user/default-image_' + size;
        }
    },

});