/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * A tool to edit parameter files 
 * @private
 */
Ext.define('Ametys.plugins.coreui.parameter.files.tool.ParameterFileEditorTool', {
	extend: "Ametys.file.AbstractFileEditorTool",

	getMessageTargetConfiguration: function ()
	{
		return {
			id: Ametys.message.MessageTarget.PARAM_FILE,
   	        parameters: {
   	        	'name': this.getFileName(), 
   	        	'path': this.getFilePath()
   	        }
   	    }
	},
	
	getMessageTargetIdForResource: function ()
	{
		return Ametys.message.MessageTarget.PARAM_FILE;
	},
	
	getMessageTargetIdForCollection: function ()
	{
		return Ametys.message.MessageTarget.PARAM_FOLDER;
	},
	
	reloadFile: function ()
	{
		this.showRefreshing();
		this.setLoaded(false);
		
		Ametys.data.ServerComm.send({
			plugin: 'core-ui',
			url: 'param/' + this.getFilePath(),
			responseType: 'text', 
			
	        callback: {
	        	handler: this._onFileLoaded,
	            scope: this,
                ignoreOnError: false
	        },
	        
	        errorMessage: { 
                msg: "{{i18n PLUGINS_CORE_UI_PARAMETERS_EDITOR_ERROR_LOADING}}"
            }
		});
	},
   
   /**
    * Callback function after {@link #reloadFile} is processed. Fills the {@link #_editor} with the file content.
    * @param {Object} response The text response provided by the {@link Ametys.data.ServerComm}
    * @param {Object} args The callback parameters passed to the {@link Ametys.data.ServerComm#send} method
    */
   _onFileLoaded: function(response, args)
   {
      if (!Ametys.data.ServerComm.isBadResponse(response))
      {
    	  this.setText(response.textContent || response.text);   	
 	      this.setLoaded(true);
 	      this.setDirty(false);
      }      
      
      this.showRefreshed();
   }
});
