/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool extends {@link Ametys.file.AbstractFileExplorerTool} to display folders and files of the parameters' root directory 'WEB-INF/param' in safe mode
 * @private
 */
Ext.define('Ametys.plugins.coreui.parameter.files.tool.ParameterFilesTool', {
    extend: "Ametys.file.AbstractFileExplorerTool",
    
    /**
     * @cfg {Boolean/String} [allowNodeEditing=true] Set to false to disable node editing.
     */
    /**
     * @protected
     * @property {Boolean} _allowNodeEditing true to enable node editing.
     */
    
    /**
     * @cfg {Boolean/String} [allowDragAndDrop=true] Set to false to disable drag&drop.
     */
    /**
     * @protected
     * @property {Boolean} _allowDragAndDrop true to enable node drag&drop.
     */
    
    constructor: function(config)
    {
        this._allowNodeEditing = config.allowNodeEditing !== "false" && config.allowNodeEditing !== false;
        this._allowDragAndDrop = config.allowDragAndDrop !== "false" && config.allowDragAndDrop !== false;
        this.callParent(arguments);
    },
    
    createTree: function()
    {
        return Ext.create("Ametys.plugins.coreui.parameter.files.ParameterFilesTree", {
            cls: 'explorer-tree',
            border: false,
            
            allowNodeEditing: this._allowNodeEditing,
            allowDragAndDrop: this._allowDragAndDrop
        });
    },
    
    openFile: function(record)
    {      
         Ametys.plugins.coreui.parameter.files.ParameterActions.open(record.get('name'), record.get('path'));
    }
});

Ext.define("Ametys.message.ParameterFileMessageTarget", {
    override: "Ametys.message.MessageTarget",
    
    statics: 
    {
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} PARAM_FILE The target type is a parameter's file. Parameters are:
         * @property {String} PARAM_FILE.name The file name
         * @property {String} PARAM_FILE.path The path into "WEB-INF/param" directory
         */
        PARAM_FILE: "parameter-file",
        
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} PARAM_FOLDER The target type is a parameter's folder. Parameters are:
         * @property {String} PARAM_FOLDER.name The file name
         * @property {String} PARAM_FOLDER.path The path into "WEB-INF/param" directory
         */
        PARAM_FOLDER: "parameter-folder",
            
        /**
         * @member Ametys.message.MessageTarget
         * @readonly
         * @property {String} PARAM_ROOT The target type is the parameter's root folder itself.
         */
        PARAM_ROOT: "parameter-folder-root"
    }
});
