/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * @private
 * Store with record containing permission target.
 * Records will be group by target type.
 */
Ext.define('Ametys.plugins.coreui.profiles.PermissionTargetStore', {
    extend: "Ext.data.Store",

    statics: {
        /**
         * @readonly
         * @property {String} TARGET_TYPE_ANONYMOUS The record is an assignment for an anonymous user
         */
        TARGET_TYPE_ANONYMOUS: 'anonymous',
        /**
         * @readonly
         * @property {String} TARGET_TYPE_ANYCONNECTEDUSER The record is an assignment for any connected user
         */
        TARGET_TYPE_ANYCONNECTEDUSER: 'anyconnected_user',
        /**
         * @readonly
         * @property {String} TARGET_TYPE_USER The record is an assignment for a user
         */
        TARGET_TYPE_USER: 'user',
        /**
         * @readonly
         * @property {String} TARGET_TYPE_GROUP The record is an assignment for a group
         */
        TARGET_TYPE_GROUP: 'group',
    },

    constructor: function(config)
    {
        config.model = config.model || "Ametys.plugins.coreui.profiles.PermissionTargetStore.Entry";
        config.grouper = {
            property: 'targetType',
            direction: 'ASC',
            transform: function (value)
            {
                // This is done to order the target types in the grid
                switch (type) {
                    case Ametys.plugins.coreui.profiles.PermissionTargetStore.TARGET_TYPE_ANONYMOUS:
                        return 0;
                    case Ametys.plugins.coreui.profiles.PermissionTargetStore.TARGET_TYPE_ANYCONNECTEDUSER:
                        return 1;
                    case Ametys.plugins.coreui.profiles.PermissionTargetStore.TARGET_TYPE_USER:
                        return 2;
                    case Ametys.plugins.coreui.profiles.PermissionTargetStore.TARGET_TYPE_GROUP:
                        return 3;
                    default:
                        return 4;
                }
            }
        };
        
        config.sortOnLoad = true;
        config.sorters = [{property: 'sortableLabel', direction:'ASC'}];
        
        this.callParent([config]);
    }
});

Ext.define('Ametys.plugins.coreui.profiles.PermissionTargetStore.Entry', {
    extend: 'Ext.data.Model',
    
    fields: [
        /* For user entries */
        {name: 'login'},
        {name: 'populationId'},
        {name: 'populationLabel'},
        {name: 'userSortableName'},
        {name: 'groups'},
        
        /* For group entries */
        {name: 'groupId'},
        {name: 'groupDirectory'},
        {name: 'groupDirectoryLabel'},
        {name: 'groupLabel'},
        
        /* For grouping feature */
        {name: 'targetType'},
        
        /* For sorting */
        {
            name: 'sortableLabel',
            type: 'string',
            type: 'string',
            
            convert: function(value, record) // using convert and not calculate because for an unknown reason, it doesn't work when closing and reopening the tool
            {
                if (record.get('userSortableName') != null)
                {
                    return record.get('userSortableName'); 
                }
                else if (record.get('groupLabel') != null)
                {
                    return record.get('groupLabel');
                }
                return "";
            }
        }
    ]
});
