/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button that will be enable only if there are assignments stored into the clipboard.
 * @private
 */
Ext.define('Ametys.plugins.coreui.profiles.controller.PasteProfileController', {
	extend: 'Ametys.ribbon.element.ui.ButtonController',
	
	constructor: function(config)
	{
		this.callParent(arguments);
        // force the button state at initialisation and freeze it until the clipboard is filled
        this.setDescription(this.getInitialConfig('empty-clipboard-description'));
        this.setAdditionalDescription('');
		this.disable();
		
		Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
	},
	
    _onModified: function (message)
    {
        var clipboardTarget = message.getTarget(Ametys.message.MessageTarget.CLIPBOARD);
        if (clipboardTarget != null)
        {
            var clipboardData = Ametys.clipboard.Clipboard.getData();
            if (clipboardData.length > 0 && Ametys.clipboard.Clipboard.getType() == Ametys.plugins.coreui.profiles.ProfilesActions.CLIPBOARD_PROFILE) 
            {
                this.setDescription(this.getInitialConfig('description'));
                this.enable();
            }
            else
            {
                this.setDescription(this.getInitialConfig('empty-clipboard-description'));
                this.setAdditionalDescription('');
                this.disable();
            }
        }
    },
    
    refresh: function()
    {
        // Prevent the update if the clipboard is empty
        var clipboardData = Ametys.clipboard.Clipboard.getData();
        if (clipboardData.length > 0 && Ametys.clipboard.Clipboard.getType() == Ametys.plugins.coreui.profiles.ProfilesActions.CLIPBOARD_PROFILE) 
        {
            this.callParent(arguments);
        }
    }

});

