/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button enabled if the current selection is a profile which can be removed (if it is not the reader profile).
 * @private
 */
Ext.define('Ametys.plugins.coreui.profile.controller.ProfileButtonController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    /**
     * @readonly
     * @property {String} READER_PROFILE_ID The id of the special profile (READER profile)
     */
    READER_PROFILE_ID: 'READER',
    
    additionalErrorDescriptionOnSelectionChanged: function(targets)
    {
        if (!targets || targets.length == 0)
        {
            // Should not happens, but prevents a possible null error.
            return "";
        }
        
        for (const target of targets)
        {
        	if (String(this.getInitialConfig("enable-on-removeable-only")) == 'true' && targets.length == 1 && target.getParameters().id == this.READER_PROFILE_ID)
            {
                return this.getInitialConfig('no-removeable-description') || '';
            }
            else if (String(this.getInitialConfig("enable-on-modifiable-only")) == 'true' && !target.getParameters().modifiable)
            {
                return this.getInitialConfig('no-modifiable-description') || '';
            }
        }
        
        return null;
    }
});