/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button toggled if the current selection is a assignment context with inheritance allowed
 * @private
 */
Ext.define('Ametys.plugins.coreui.profile.controller.ProfileContextInheritanceController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     */
    _onModified: function (message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    areSameTargets: function (target1, target2)
    {
        if (target1.getParameters().context && target2.getParameters().context)
        {
            return target1.getParameters().context == target2.getParameters().context;
        }
        return false;
    },
    
    updateState: function()
    {
        var targets = this.getMatchingTargets();
        
        if (targets.length > 0)
        {
            var inheritanceAvailable = targets[0].getParameters().inheritanceAvailable;
            if (!inheritanceAvailable)
            {
                this.disable(); 
                this.toggle(false);
                this.setIconDecorator();
                this.setAdditionalDescription(this.getInitialConfig("inheritance-unavailable-description"));
            }
            else
            {
                var inheritanceDisallowed = targets[0].getParameters().inheritanceDisallowed;
                this.enable();
	            this.toggle(!inheritanceDisallowed);
	            
	            if (inheritanceDisallowed)
	            {
	                this.setAdditionalDescription(this.getInitialConfig("inheritance-off-description"));
	                this.setIconDecorator(this.getInitialConfig("inheritance-off-decorator"));
	                this.setIconDecoratorType(this.getInitialConfig("inheritance-off-decorator-type"));
	            }
	            else
	            {
	                this.setAdditionalDescription(this.getInitialConfig("inheritance-on-description"));
	                this.setIconDecorator(this.getInitialConfig("inheritance-on-decorator"));
	                this.setIconDecoratorType(this.getInitialConfig("inheritance-on-decorator-type"));
	            }
            }
            
        }
    }
});