/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Unsafe script actions (like asynchronous execution).
 * @private
 */
Ext.define('Ametys.plugins.coreui.script.AsyncScriptActions',
{
    singleton: true,
    
    /**
     * Handles the execute async script button ("play").
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The button controller.
     */
    executeAsyncScript: function(controller)
    {
        var tool = Ametys.tool.ToolsManager.getFocusedTool();
        if (tool != null)
        {
            var script = tool.scriptEditor.getValue();
            
            if (Ametys.plugins.coreui.script.ScriptParameters.hasScriptParameters(script))
            {
                Ametys.log.ErrorDialog.display({
                    title: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_PARAMETERS_ASYNC}}", 
                    text: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_PARAMETERS_ASYNC_ERROR}}",
                    category: "Ametys.plugins.coreui.script.ScriptParameters"
                });
                return;
            }
            
            // remove the surrounding function: function main { ... }
            script = script.substring(script.indexOf('{') + 1, script.lastIndexOf('}'));
            
            Ametys.plugins.coreui.script.AsyncScriptDialog.open({
                serverCallFn: serverCallFn,
                scope: this
            });
            
            function serverCallFn(params)
            {
                controller.serverCall(
                    "add",
                    [
                        "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_EXECUTE_ASYNC_TASK_TITLE}}",
                        "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_EXECUTE_ASYNC_TASK_DESCRIPTION}}",
                        "NOW",
                        "",
                        "org.ametys.core.schedule.Script",
                        {
                            "org.ametys.core.schedule.Script$recipient": params.recipient,
                            "org.ametys.core.schedule.Script$script": script
                        }
                    ],
                    Ext.bind(this._executeAsyncScriptCb, this),
                    {
                        waitMessage: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_WAITING_MESSAGE}}",
                        errorMessage: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_EXECUTE_ERROR}}"
                    }
                );
            }
        }
    },
    
    /**
     * Callback fired when the script asynchronous execution has finished: notify a message.
     * @param {Object} result The request result.
     * @private
     */
    _executeAsyncScriptCb: function(result)
    {
        Ametys.notify({
            title: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_EXECUTE_ASYNC_NOTIFY_TITLE}}",
            description: "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_EXECUTE_ASYNC_NOTIFY_DESC}}"
        });
    }
});
