/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This class is a singleton class to helper for the script tool
 * @private
 */
Ext.define('Ametys.plugins.coreui.script.ScriptToolHelper', {
    singleton: true,
    
    /**
     * @private
     * @property {Ext.Template} _scriptDateTpl HTML fragment template used for displaying script duration and datetime
     */
    _scriptDateTpl: Ext.create('Ext.Template', '<div class="result-header"><span>',
            "{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_RESULT_MSG}}",
            '{date} ({duration}',
            ')</span></div>'),
            
       
    /**
     * Format the console output
     * @param {Object} result The script result to format
     * @return {String} the result to HTML format
     */
    formatConsoleOutput: function (result) 
    {
        var id = Ext.id();
        var html = "<div id='" + id + "'>";

        var start = Ext.isDate(result.start) ? result.start : new Date(result.start);
        var end = Ext.isDate(result.end) ? result.end : new Date(result.end);
        
        var duration = (end.getTime() - start.getTime());
        
        if (!Ext.isEmpty(result.output))
        {
            html += '<pre>' + result.output + '</pre>';
        }
        if (!Ext.isEmpty(result.result))
        {
            html += Ext.JSON.prettyEncode(result.result, 0/*, function(value, offset) { FIXME move this to repository / or make a generic opentool feature 
                if (Ext.isObject(value) && value.type == 'node' && value.path != null)
                {
                    return value.path;
                }
                if (Ext.isObject(value) && value.type == 'ametys-object' && value.path != null)
                {
                    return value.path + " [" + value.id + "]";
                }
            }*/);
        }
        if (!Ext.isEmpty(result.error))
        {
            html += '<div class="error">' + result.error + '</div>';
        }
        if (Ext.isEmpty(result.output) && Ext.isEmpty(result.result) && Ext.isEmpty(result.error))
        {
            html += "<div class='no-result'>{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_RESULTS_NO_RESULT}}</div>";
        }
        if (!Ext.isEmpty(result.stacktrace))
        {
            html += '<div class="fatalerror">' + result.message
                    + "<br/><a href='javascript:void(0)' onclick='this.nextSibling.style.display = (this.nextSibling.style.display == \"none\" ? \"\" : \"none\")'>{{i18n PLUGINS_CORE_UI_TOOLS_SCRIPT_ERROR_DETAILS}}</a>"
                    + "<div class='stacktrace' style='display: none'>" + Ext.String.stacktraceJavaToHTML(result.stacktrace) + "</div>"
                    + '</div>';
        }
        
        html += this._scriptDateTpl.apply ({date: Ext.Date.format(end, Ext.Date.patterns.ShortTime), duration: Ext.util.Format.duration(duration)});
        html += '</div>';

        return html;
    }
});
