/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for entries in the grid of the request tracker tool
 * @private
 */
Ext.define("Ametys.plugins.coreui.system.requesttracker.RequestTrackerTool.RequestEntry", {
	extend: 'Ext.data.Model',
	
    fields: [
        // Both level
		{name: 'name', type: 'string'}, // 1 1.0
		{name: 'response'},
        {name: 'status'}, // ok/canceled/error or 200 500 404
		
		// Top level
		{name: 'type'}, // Async or Sync
		{name: 'date', type: 'date', dateFormat: 'Y-m-d'},
        {name: 'globalDuration'},
        {name: 'serverSideDuration'},
		{name: 'errors', calculate: function (data) { return data.children && data.globalDuration != null ? data.children.reduce((partialSum, a) => partialSum + (a.data.status && a.data.status != 200 ? 1 : 0), 0) : null }}, // nb of errors in children
		
		// Bottom level
        {name: 'message'}, // The message used to send the request
        {name: 'callstack', calculate: function(data) { return data.message ? data.message.callstack : null}}, // plugin name of the url
        {name: 'plugin', calculate: function(data) { return data.message ? data.message.plugin : null}}, // plugin name of the url
        {name: 'workspace', calculate: function(data) { return data.message ? data.message.workspace : null}}, // workspace name of the url
        {name: 'url', calculate: function(data) { return data.message ? Ametys.plugins.coreui.system.requesttracker.RequestTrackerTool.RequestEntry._removeGetParameters(data.message.url) : null}}, // The url
        {name: 'clientCall', calculate: function(data) { return data.message ? Ametys.plugins.coreui.system.requesttracker.RequestTrackerTool.RequestEntry._getClientCallInfo(data.message) : null}}, // The infos with callable
        {name: 'returnType', calculate: function(data) { return data.message ? data.message.responseType : null}}, // xml text xml2text
    ],
    
    statics: {
        /**
         * @private
         * Remove the GET request parameters from the url
         * @param url The url 
         * @returns The request url without the GET paramters
         * @private
         */
        _removeGetParameters: function (url)
        {
            var i = url.indexOf("?");
            if (i == -1) return url;
            else return url.substring(0, i);
        },
        
        _getClientCallInfo:function (message)
        {
            if (message && message.url == "client-call" && message.plugin == "core-ui")
            {
                return {
                    role: message.parameters ? message.parameters.role : null,
                    id: message.parameters ? message.parameters.id : null,
                    method: message.parameters ? message.parameters.methodName : null
                }
            }
            else
            {
                return null
            }
        }   
    } 
});