/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button allowing to pause or unpause the current tool.
 * The targeted tool should provide a methode #isRunning() indicating if the tool is currently running or paused
 *
 * When the focused tool is paused, the button will be toggled and an additionnal description provided by #cfg-description-play will be displayed
 */
Ext.define('Ametys.plugins.coreui.tools.PauseToolController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    
    updateState: function(message)
    {
        this.callParent(arguments);
        
        var target = this.getMatchingToolTargets()[0];
        if (target != null)
        {
            var tool = Ametys.tool.ToolsManager.getTool(target.getParameters().id);
            if (tool != null && typeof tool.isRunning == "function")
            {
                this.toggle(!tool.isRunning());
            }
            else
            {
                this.toggle(false);
            }
        
        }
    },
    /**
     * Override to add a description stating that the tool is paused
     */
    toggle: function(pause)
    {
        this.callParent(arguments);
        if (pause)
        {
            this.setAdditionalDescription(this.getInitialConfig("description-play"));
        }
        else
        {
            this.setAdditionalDescription("");
        }
    }
});
