/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * The model for the Ametys.timeline.Timeline.TimelineStore of a Ametys.timeline.Timeline
 */
Ext.define('Ametys.timeline.Timeline.TimelineItem', {
    extend : 'Ext.data.Model',

    fields : [ 'id',
               'username',
               'profileImg',
               {name: 'type',  type: 'string', defaultValue: 'info'},
               { name: 'read', type: 'boolean', defaultValue: false},
               { name: 'date', type: 'date'},
               {
                    name: 'day',
                    type: 'date',
                    depends: ['date'],
                    calculate: function (data)
                    {
                        // Remove hours/minutes
                        var formattedDate = Ext.Date.format(data.date, "{{i18n PLUGINS_CORE_UI_TIMELINE_DATE_FORMAT}}");
                        return Ext.Date.parse(formattedDate, "{{i18n PLUGINS_CORE_UI_TIMELINE_DATE_FORMAT}}");
                    }
               },
               {
                    name: 'hour',
                    depends: ['date'],
                    calculate: function (data)
                    {
                        return Ext.Date.format(data.date, "{{i18n PLUGINS_CORE_UI_TIMELINE_HOUR_FORMAT}}");
                    }
              },
              'text',
              'comment',
              'topText',
              'icon',
              'iconGlyph',
              'lastModified',
              'canDelete',
              'canEdit'
     ]
});
