/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * Inspired by jQuery Minimun Password Requirements 1.1
 * http://elationbase.com
*/
  
  
(function($){
    $.fn.extend({
        passwordRequirements: function(options) {
            
            // options for the plugin
            var defaults = {
                uniqueId: Math.random().toString(16).slice(2),
				numCharacters: 8,
				minLowercase: 0,
				minUppercase: 0,
				minNumbers: 0,
				minSpecials: 0,
                invalidStyle: 'invalid',
				weakStyle: "pr-weak", // Style Options light or dark
                strongStyle: "pr-strong", // Style Options light or dark
				fadeTime:300, // FadeIn / FadeOut in milliseconds
                lowerCaseRe: new RegExp('[a-z]'),
                upperCaseRe: new RegExp('[A-Z]'),
                numbersRe: new RegExp('[0-9]'),
                specialCharacters: '!%&@#$^*?_~'
            };

            options =  $.extend(defaults, options);
            
            options.lowerCaseRe = new RegExp('^(.*[a-z].*){' + options.minLowercase + ',}$');
            options.upperCaseRe = new RegExp('^(.*[A-Z].*){' + options.minUppercase + ',}$')
            options.numbersRe = new RegExp('^(.*[0-9].*){' + options.minNumbers + ',}$');
            var regexpSpecialChars = /([\[\]\^\$\|\(\)\\\+\*\?\{\}\=\!])/gi;
            var quotedSpecialCharacters = options.specialCharacters.replace(regexpSpecialChars, '\\$1');
            options.specialCharacterRe = new RegExp('^(.*[' + quotedSpecialCharacters + '].*){' + options.minSpecials + ",}$");
            
            return this.each(function() {
				
                var $this = $(this);
				var o = options;
                
                var requirements = [];
                
				// Add Variables for the li elements
				var numCharactersUI = '<li class="pr-numCharacters"><span></span>' + "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_LENGTH}}".replace("{0}", o.numCharacters) + '</li>',
					minLowercaseUI = '',
					minUppercaseUI = '',
					minNumbersUI   = '',
					minSpecialUI   = '';
				// Check if the options are checked
				if (o.minLowercase > 0) {
					minLowercaseUI = '<li class="pr-useLowercase"><span></span>' + (o.minLowercase == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_LOWERCASE}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_LOWERCASE}}".replace("{0}", o.minLowercase)) + '</li>';
                    requirements.push(o.minLowercase == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_LOWERCASE}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_LOWERCASE}}".replace("{0}", o.minLowercase));
				}
				if (o.minUppercase > 0) {
					minUppercaseUI = '<li class="pr-useUppercase"><span></span>' + (o.minUppercase == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_UPPERCASE}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_UPPERCASE}}".replace("{0}", o.minUppercase)) + '</li>';
                    requirements.push(o.minUppercase == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_UPPERCASE}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_UPPERCASE}}".replace("{0}", o.minUppercase));
				}
				if (o.minNumbers > 0) {
					minNumbersUI = '<li class="pr-useNumbers"><span></span>' + (o.minNumbers == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_NUMBERS}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_NUMBERS}}".replace("{0}", o.minNumbers)) + '</li>';
                    requirements.push(o.minNumbers == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_NUMBERS}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_NUMBERS}}".replace("{0}", o.minNumbers));
				}
				if (o.minSpecials > 0) {
					minSpecialUI = '<li class="pr-useSpecial"><span></span>' + (o.minSpecials == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_SPECIAL}}".replace("{0}", o.specialCharacters) : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_SPECIALS}}".replace("{0}", o.minSpecials).replace("{1}", o.specialCharacters)) + '</li>';;
                    requirements.push(o.minSpecials == 1 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_USE_SPECIAL_HINT}}" : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_MIN_SPECIALS_HINT}}".replace("{0}", o.minSpecials));
				}
                
                // Build info message
                o.infoMessage = requirements.length > 0 ? "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_REQUIREMENTS_HINT}}".replace("{numCharacters}", o.numCharacters).replace("{requirements}", requirements.join(', ')) : "{{i18n plugin.core-ui:PLUGINS_CORE_UI_PASSWORD_MINIMAL_LENGTH_HINT}}".replace("{numCharacters}", o.numCharacters);
				
				// Append password hint div
				var messageDiv = '<div id="pr-box-' + o.uniqueId + '" class="pr-box"><i></i><div class="pr-box-inner"><p>' + o.infoMessage + '</p><ul>' + numCharactersUI + minLowercaseUI + minUppercaseUI + minNumbersUI + minSpecialUI + '</ul></div></div>';
                
				// Set campletion vatiables
				var numCharactersDone = true,
					minLowercaseDone = true,
					minUppercaseDone = true,
					minNumbersDone   = true,
					minSpecialDone   = true;
                
                // Prepare message
                var prepareMessage = function() {
                    var $prBox = $("#pr-box-" + o.uniqueId);
                    if (!$prBox.length)
                    {
                       // Append info box tho the body
                        $("body").append(messageDiv); 
                    }
                    
                    return $prBox;
                }
                   
				// Show Message reusable function 
				var showMessage = function () {
					if (numCharactersDone === false || minLowercaseDone === false || minUppercaseDone === false || minNumbersDone === false || minSpecialDone === false) {
						var posH = $this.offset().top,
                            itemH = $this.outerHeight(),
                            totalH = posH + itemH,
                            itemL = $this.offset().left;
                        
                        $prBox = $("#pr-box-" + o.uniqueId);
                        $prBox.fadeIn(o.fadeTime)
                              .css({top:totalH, left:itemL});
					}
				};
				
				// Show password hint 
				$(this).on("focus",function (){
                    prepareMessage();
					showMessage();
				});
				
				// Delete Message reusable function 
				var deleteMessage = function () {
					var targetMessage = $("#pr-box-" + o.uniqueId);
					targetMessage.fadeOut(o.fadeTime);
				};
				
				// Show / Delete Message when completed requirements function 
				var checkCompleted = function () {
					if (numCharactersDone === true && minLowercaseDone === true && minUppercaseDone === true && minNumbersDone === true && minSpecialDone === true) {
						deleteMessage();
                        
                        $this.removeAttr('data-pr-invalid');
                        $this.closest('.input').removeClass(o.invalidStyle);
					} else {
						showMessage();
                        
                        $this.attr('data-pr-invalid', 'true');
                        $this.closest('.input').addClass(o.invalidStyle);
					}
				};
				
				// Show password hint 
				$(this).on("blur",function (){
					deleteMessage();
				});
				
				
				// Show or Hide password hint based on keyup
				$(this).on("keyup focus", function (){
					var thisVal = $(this).val();  
                    
                    var $prBox = prepareMessage();
                    
                    var nbRequirementsOk = 0;
                    var nbRequirements= 1;
                    
					// Check # of characters
					if ( thisVal.length >= o.numCharacters ) {
						// console.log("good numCharacters");
						$prBox.find(".pr-numCharacters span").addClass("pr-ok");
						numCharactersDone = true;
                        nbRequirementsOk++;
					} else {
						// console.log("bad numCharacters");
						$prBox.find(".pr-numCharacters span").removeClass("pr-ok");
						numCharactersDone = false;
					}
					// lowerCase meet requirements
					if (o.minLowercase > 0) {
						if ( thisVal.match(o.lowerCaseRe) ) {
							// console.log("good lowerCase");
							$prBox.find(".pr-useLowercase span").addClass("pr-ok");
							minLowercaseDone = true;
                            nbRequirementsOk++;
						} else {
							// console.log("bad lowerCase");
							$prBox.find(".pr-useLowercase span").removeClass("pr-ok");
							minLowercaseDone = false;
						}
                        nbRequirements++;
					}
					// upperCase meet requirements
					if (o.minUppercase > 0) {
						if ( thisVal.match(o.upperCaseRe) ) {
							// console.log("good upperCase");
							$prBox.find(".pr-useUppercase span").addClass("pr-ok");
							minUppercaseDone = true;
                            nbRequirementsOk++;
						} else {
							// console.log("bad upperCase");
							$prBox.find(".pr-useUppercase span").removeClass("pr-ok");
							minUppercaseDone = false;
						}
                        nbRequirements++;
					}
					// upperCase meet requirements
					if (o.minNumbers > 0) {
						if ( thisVal.match(o.numbersRe) ) {
							// console.log("good numbers");
							$prBox.find(".pr-useNumbers span").addClass("pr-ok");
							minNumbersDone = true;
                            nbRequirementsOk++;
						} else {
							// console.log("bad numbers");
							$prBox.find(".pr-useNumbers span").removeClass("pr-ok");
							minNumbersDone = false;
						}
                        nbRequirements++;
					}
					// upperCase meet requirements
					if (o.minSpecials > 0) {
						if ( thisVal.match(o.specialCharacterRe) ) {
							// console.log("good specialCharacter");
							$prBox.find(".pr-useSpecial span").addClass("pr-ok");
							minSpecialDone = true;
                            nbRequirementsOk++;
						} else {
							// console.log("bad specialCharacter");
							$prBox.find(".pr-useSpecial span").removeClass("pr-ok");
							minSpecialDone = false;
						}
                        nbRequirements++;
					}
                    
                    if (nbRequirementsOk == nbRequirements)
                    {
                        // All requirements are OK
                        $prBox.addClass(o.strongStyle);
                        $prBox.removeClass(o.weakStyle)
                    }
                    else if (nbRequirementsOk > 0)
                    {
                        // At least one requirements complete
                        $prBox.addClass(o.weakStyle);
                        $prBox.removeClass(o.strongStyle);
                    }
                    else
                    {
                        // All requirements are OK
                        $prBox.removeClass(o.weakStyle);
                        $prBox.removeClass(o.strongStyle);
                    }
                    
                    checkCompleted();
				});
            });
        }
    });
})(jQuery);
