Ametys.progressionTracker.setSteps([
    { id: 'init', label: "Initialization", /* weight: 1 */ },
    { id: 'work', label: "Work", weight: 98 },
    { id: 'finish', label: "Finalization", /* weight: 1 */ }
]);

// Initialization
// ...
Ametys.progressionTracker.increment('init'); // Default size is 1, so incrementing here is going to complete the step
                                      // Global progression is now 1% 

// Work
Ametys.progressionTracker.getStep('work').withLoggerGranularity(20); // Log every 20 increments (default is 500)
Ametys.progressionTracker.setSize('work', 200);
for (var i = 0; i < 200; i++)
{
    // ...
    Ametys.progressionTracker.increment('work'); // Increment of 1
}
// Global progression is now 99% 

// Finalization
Ametys.progressionTracker.setSize('finish', 3);
// ...
Ametys.progressionTracker.increment('finish', 2); // Increment of 2
// ...
Ametys.progressionTracker.increment('finish'); // Increment of 1