// Search 'runtime' in the config/config.xml file located in the AMETYS_HOME
if (Ametys.utils.contains("ametys-home://config/config.xml", "runtime"))
{
    print("runtime is present");
}

// In the file /WEB-INF/param/runtime.xml, search any occurrence of 'org.ametys.*'
if (Ametys.utils.contains("context://WEB-INF/param/runtime.xml", /org\.ametys.*/g))
{
    print("found text that matches the regexp");
}

let re = new RegExp("encoding=\"([^\"]+)\"");
try
{
    if (Ametys.utils.contains("ametys-home://config/config.xml", re))
    {
        print("Encoding is " +  RegExp.$1);
    }
    else
    {
        print("No encoding specified");
    }
}
catch (e)
{
    print("Cannot determine encoding of file: " + e)
}
