const typedArray = TypeHelper.newTypedArray('java.lang.String');
typedArray.push('one');
typedArray.push('two');
// jcrProperty.setValue(['one', 'two']) would not work as GraalVM is not able to infer the type of the signature between setValue(String[] values) and setValue(Value[] values)
jcrProperty.setValue(typedArray.toJavaArray());

// you can also pass the type instead of a string
const JString = Java.type('java.lang.String');
const anotherTypedArray = TypeHelper.newTypedArray(JString);
anotherTypedArray.push('three');
anotherTypedArray.push('four');
jcrProperty.setValue(anotherTypedArray.toJavaArray());

const javaArray = TypeHelper.newTypedArray('java.lang.String', ['five', 'six']).toJavaArray();
jcrProperty.setValue(javaArray);
