/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('Ametys', {
    serviceManager: __internal_ametys_serviceManager,
    sourceResolver: __internal_ametys_sourceResolver,
    avalonContext: __internal_ametys_avalonContext,
    progressionTracker: __internal_ametys_progressionTracker,
    console: {
        log: function(...message) { print("<span class='info'>[INFO] " + message.join(' ') + "</span>"); },
        debug: function(...message) { print("<span class='debug'>[DEBUG] " + message.join(' ') + "</span>"); },
        info: function(...message) { print("<span class='info'>[INFO] " + message.join(' ') + "</span>"); },
        warn: function(...message) { print("<span class='warn'>[WARN] " + message.join(' ') + "</span>"); },
        error: function(...message) { print("<span class='error'>[ERROR] " + message.join(' ') + "</span>"); },
        fatal: function(...message) { print("<span class='fatalerror'>[FATAL] " + message.join(' ') + "</span>"); }
    }
});

// Obsolete
serviceManager = Ametys.serviceManager;
sourceResolver = Ametys.sourceResolver;
avalonContext = Ametys.avalonContext;