/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Ametys.namespace("Ametys", (function() {

            // Imports
        const LogManager = Java.type("org.apache.log4j.LogManager");
        const Level = Java.type("org.apache.log4j.Level");
        const AmetysHomeHelper = Java.type("org.ametys.runtime.util.AmetysHomeHelper");
        const PatternLayout = Java.type("org.apache.log4j.PatternLayout");
        const RollingFileAppender = Java.type("org.apache.log4j.rolling.RollingFileAppender");
        const TimeBasedRollingPolicy = Java.type("org.apache.log4j.rolling.TimeBasedRollingPolicy");
        
        // Static variables
        var PATTERN_LAYOUT = new PatternLayout("%d %-5p [%c] (%t;%X{requestURI}) %m%n");
        
        function getLogger(category, options)
        {
            options = options || {};
            
            var logger = _getLogger(category, options.level);
            
            var additivity
            if (options.additivity != undefined)
            {
                additivity = options.additivity
            }
            else
            {
                //si il y a un fichier => false
                additivity = options.filename == undefined
            }
            logger.setAdditivity(additivity);
            if(options.filename != undefined)
            {
                _addAppenderIfNecessary(logger, options.filename);
            }
            return _createLoggerObject(logger);
        }
        
        function _getLogger(category, level)
        {
            var logger = LogManager.getLogger(category);
            if(level != undefined)
            {
                logger.setLevel(Level.toLevel(level));
            }
            return logger;
        }
        
        function _addAppenderIfNecessary(logger, filename)
        {
            if (logger.getAppender(filename) == null)
            {
                logger.addAppender(_createAppender(filename));
            }
        }
        
        function _createAppender(filename)
        {
            var filePattern = AmetysHomeHelper.getAmetysHome() + "/logs/" + filename + "-%d.log";
            var rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setFileNamePattern(filePattern);
            
            // Create and configure the appender
            var fileAppender = new RollingFileAppender();
            fileAppender.setName(filename);
            fileAppender.setEncoding("UTF-8");
            fileAppender.setLayout(PATTERN_LAYOUT);
            fileAppender.setRollingPolicy(rollingPolicy);
            fileAppender.activateOptions();
            return fileAppender;
        }
        
        function _createLoggerObject(logger)
        {
            function debug(message)
            {
                Ametys.console.debug(message);
                logger.debug(message);
            }
            
            function info(message)
            {
                Ametys.console.info(message);
                logger.info(message);
            }
            
            function warn(message)
            {
                Ametys.console.warn(message);
                logger.warn(message);
            }
            
            function error(message, exception)
            {
                Ametys.console.error(message);
                if (exception === undefined)
                {
                    logger.error(message);
                }
                else
                {
                    exception = exception instanceof java.lang.Throwable ? exception : new java.lang.RuntimeException(exception.toString());
                    logger.error(message, exception);
                }
            }
            
            function fatal(message, exception)
            {
                Ametys.console.fatal(message);
                if (exception === undefined)
                {
                    logger.fatal(message);
                }
                else
                {
                    exception = exception instanceof java.lang.Throwable ? exception : new java.lang.RuntimeException(exception.toString());
                    logger.fatal(message, exception);
                }                
            }
            
            return {
                info: info,
                warn: warn,
                debug: debug,
                fatal: fatal,
                error: error
            };
        }

        return {
            getLogger
        }
    })()
);
