/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Ametys.namespace('Ametys', (function() {

        function toArray(arg)
        {
            if (typeof arg == "object" && Array.isArray(arg))
            {
                return arg;
            }
            else
            {
                return [arg];
            }
        }
        

        function mail(options) 
        {
            const subject = options.subject;
            
            if(subject == undefined)
            {
                throw new Error("subject is mandatory")
            }
            const htmlBody = options.htmlBody;
            const textBody = options.textBody;
            if(htmlBody == undefined && textBody == undefined)
            {
                throw new Error("Either htmlBody or textBody should be defined")
            }
            const toRecipients = toArray(options.toRecipients, "toRecipients");
            const ccRecipients = toArray(options.ccRecipients || [], "ccRecipients");
            const bccRecipients = toArray(options.bccRecipients || [], "bccRecipients");
            
            if (toRecipients.length == 0)
            {
                throw new Error("toRecipients should not be empty")
            }
            
            const singleMail = options.singleMail !== false ? true : false;
            
            var attachments = null;
            if (options.attachments)
            {
                options.attachments = toArray(options.attachments);
                
                attachments = new java.util.ArrayList();
                for (var f in options.attachments)
                {
                    attachments.add(options.attachments[f]);
                }
            }

            const deliveryReceipt = options.deliveryReceipt === true ? true : false;
            const readReceipt = options.readReceipt === true ? true : false;
            const async = options.async === true ? true : false;
            const SendMailHelper = Java.type("org.ametys.core.util.mail.SendMailHelper");
            const Config = Java.type("org.ametys.runtime.config.Config");
            config = Config.getInstance();
            const sender = options.sender || config.getValue("smtp.mail.from");

            SendMailHelper.newMail()
                          .withSubject(subject)
                          .withHTMLBody(htmlBody)
                          .withTextBody(textBody)
                          .withAttachments(attachments)
                          .withRecipients(toRecipients)
                          .withSender(sender)
                          .withCc(ccRecipients)
                          .withBcc(bccRecipients)
                          .withDeliveryReceipt(deliveryReceipt)
                          .withReadReceipt(readReceipt)
                          .withSingleEmail(singleMail)
                          .withAsync(async)
                          .sendMail();
        }

        return {
            mail
        }
    })()
);