/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('Ametys.utils', (function() {
    function newTypedArray(typeOfElements, elements = []) 
    {
        const arrayType = computeArrayType(typeOfElements);
        return new TypedArray(arrayType, elements);
    }

    function computeArrayType(typeOfElements) 
    {
        let typeOfElementsAsString = typeOfElements;
        if (typeof typeOfElements !== "string") {
            // it is already a type, was instanciated with Java.type('???')
            typeOfElementsAsString = typeOfElements.class.getName();
        }
        const arrayType = Java.type(`${typeOfElementsAsString}[]`);
        return arrayType;
    }

    class TypedArray 
    {
        constructor(arrayType, elements) 
        {
            this.arrayType = arrayType;
            this.els = elements;
        }

        push(el) 
        {
            this.els.push(el);
        }

        toJavaArray() 
        {
            const JArray = this.arrayType;
            const javaArray = new JArray(this.els.length);
            for (const i in this.els) {
                const el = this.els[i];
                javaArray[i] = el;
            }
            return javaArray;
        }
    }

    return {
        newTypedArray
    };
})());

// Obsolete 
Ametys.namespace('TypeHelper', { newTypedArray: function(typeOfElements, elements) {
    Ametys.console.warn("TypeHelper.newTypedArray is obsolete. Use Ametys.utils.newTypedArray instead.");
    return Ametys.utils.newTypedArray(typeOfElements, elements);
}});