/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('Ametys.utils', (function() {
    const IOUtils = Java.type("org.apache.commons.io.IOUtils");
    
    function searchAndReplace(sourceURI, pattern, replacement) 
    {
        let src, is, os, content;
        
        try
        {
            src = Ametys.sourceResolver.resolveURI(sourceURI);
            
            // Ignore if the source does not exist
            if (!src.exists())
            {
                return false;
            }
            
            is = src.getInputStream();
            content = IOUtils.toString(is, "UTF-8");
            
            let newContent = content.replace(pattern, replacement);
            if (newContent === content)
            {
                return false;
            }
            else
            {
                os = src.getOutputStream();
                IOUtils.write(newContent, os, "UTF-8");
                
                return true;
            }
        }
        catch (e)
        {
            if (e instanceof org.apache.excalibur.source.SourceNotFoundException)
            {
                return false;
            }
            throw e;
        }
        finally
        {
            if (is != null)
            {
                IOUtils.closeQuietly(is);
            }
            if (os != null)
            {
                IOUtils.closeQuietly(os);
            }
            Ametys.sourceResolver.release(src);
        }
    }

    return {
        searchAndReplace
    };
})());
