/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
Ametys.namespace('SQL', {
    query: function (query, dataSource, options) {
        dataSource = dataSource || "SQL-default-datasource";
        options = typeof options == 'boolean' ? { printToConsole: options } : (options || {});
        options.registerId = options.registerId || "__all_connections__";
        
        const ConnectionHelper = Java.type('org.ametys.core.datasource.ConnectionHelper');
    
        if (typeof dataSource === "string")
        {
            dataSource = Ametys.serviceManager.lookup("org.ametys.core.datasource.SQLDataSourceManager").getSQLDataSource(dataSource);
        }
    
        const connection = dataSource.getConnection();
        __cleanup_manager.register(options.registerId, function() {
            ConnectionHelper.cleanup(connection);
        });
        
        const stmt = connection.prepareStatement(query, java.sql.ResultSet.TYPE_SCROLL_SENSITIVE, java.sql.ResultSet.CONCUR_UPDATABLE);
        __cleanup_manager.register(options.registerId, function() {
            ConnectionHelper.cleanup(stmt);
        });
        
        const rs = stmt.executeQuery();
        __cleanup_manager.register(options.registerId, function() {
            rs.close();
        });

        if (options.printToConsole)
        {
            const StringUtils = Java.type('org.apache.commons.lang3.StringUtils');
            const colCount = rs.getMetaData().getColumnCount();
          
            let maxColLabelLength = 0;
            const colLabels = ['1BasedArray'];
            for (let i = 1; i <= colCount; i++)
            {
                const colLabel = rs.getMetaData().getColumnLabel(i);
                colLabels.push(colLabel);
                maxColLabelLength = Math.max(colLabel.length, maxColLabelLength);
            }
          
          
            let count = 1;
          
            while (rs.next())
            {
               print(`#${count}`);  
               for (let i = 1; i <= colCount; i++)
               {
                 print(`\t${StringUtils.rightPad(colLabels[i], maxColLabelLength)} : ${rs.getString(i)}`);
               }
               print("\n");
              count++;
            }
            
            print(`${(count-1)} result(s) found\n`);
            
            rs.beforeFirst();
        }
        
        return rs;
    },
    
    cleanup: function(registerId)
    {
        __cleanup_manager.cleanup(registerId);
    }
});


// Obsolete
function sqlQuery(query, dataSource) {
    Ametys.console.warn("sqlQuery is obsolete. Use SQL.query instead.");
    return SQL.query(query, dataSource);
}
 function printSqlQuery(query, dataSource) {
    Ametys.console.warn("printSqlQuery is obsolete. Use SQL.query instead.");
    return SQL.query(query, dataSource, true);
 }