/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ametys.namespace('SQL', {
    update: function (update, dataSource) {
        if (typeof dataSource === "string")
        {
            dataSource = Ametys.serviceManager.lookup("org.ametys.core.datasource.SQLDataSourceManager").getSQLDataSource(dataSource);
        }

	    let connection;
	    let stmt;
	    
        try
        {
            connection = dataSource.getConnection();
            stmt = connection.prepareStatement(update);
            
            return stmt.executeUpdate();
        }
        finally
        {
            const ConnectionHelper = Java.type('org.ametys.core.datasource.ConnectionHelper');
        
        	if (stmt)
        	{
            	ConnectionHelper.cleanup(stmt);
            }
            if (connection)
            {	
            	ConnectionHelper.cleanup(connection);
            }
        }
    } 
});


// Obsolete
function sqlUpdate(update, dataSource) {
    Ametys.console.warn("sqlUpdate is obsolete. Use SQL.update instead.");
    return SQL.update(update, dataSource);
}
