<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="user-input.xsl"/>
    <xsl:import href="details.xsl"/>
    <xsl:import href="button.xsl"/>
    
    <xsl:template name="content">
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        
        <td align="center"
            style="
                    direction: ltr;
                    font-size: 0px;
                    padding: 0px;
                    word-break: break-word;
                    background-color: {$content-bg-color};
                    border-radius: {$content-border-radius};">
            <table>
                <xsl:call-template name="table-layout-attributes" />
    
                <tbody>
                    <tr>
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$padding-left"/>
                        </xsl:call-template>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
    
                            <!-- Header with logo -->
                            <xsl:call-template name="header" />
                            <!-- Inner content -->
                            <xsl:call-template name="content-inner" />
                        </td>
                        
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width" select="$padding-right"/>
                        </xsl:call-template>
                    </tr>
                </tbody>
            </table>
        </td>
    </xsl:template>
    
    <xsl:template name="content-inner">
        <!-- Title -->
        <xsl:apply-templates select="title" mode="message"/>
        
        <!-- Message -->
        <xsl:call-template name="messages"/>
        
        <!-- User inputs -->
        <xsl:call-template name="user-inputs"/>
        
        <!-- Button link -->
        <xsl:apply-templates select="link" mode="button"/>
        
        <!-- Details -->
        <xsl:apply-templates select="details"/>
    </xsl:template>
    
    <xsl:template match="title" mode="message">
        <xsl:param name="width">500</xsl:param>
        <xsl:param name="margin-top">0</xsl:param>
        <xsl:param name="margin-bottom">35</xsl:param>
        <xsl:param name="margin-left">20</xsl:param>
        <xsl:param name="margin-right">20</xsl:param>
        
        <xsl:call-template name="content-title">
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="margin-top" select="$margin-top"/>
            <xsl:with-param name="margin-bottom" select="$margin-bottom"/>
            <xsl:with-param name="margin-left" select="$margin-left"/>
            <xsl:with-param name="margin-right" select="$margin-right"/>
            <xsl:with-param name="title" select="."/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="content-title">
        <xsl:param name="width">500</xsl:param>
        <xsl:param name="margin-top">0</xsl:param>
        <xsl:param name="margin-bottom">35</xsl:param>
        <xsl:param name="margin-left">20</xsl:param>
        <xsl:param name="margin-right">20</xsl:param>
        <xsl:param name="title"/>
    
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
    
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-top"/>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                    <tr>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$margin-left"/>
                                        </xsl:call-template>
                                        <td>
                                            <xsl:call-template name="td-center-layout-attributes" />
                                            <span class="page-heading">
                                                <xsl:call-template name="title-style"/>
                                                <xsl:value-of select="$title" disable-output-escaping="yes"/>
                                            </span>
                                        </td>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width" select="$margin-right"/>
                                        </xsl:call-template>
                                    </tr>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-bottom"/>
                                        <xsl:with-param name="colspan">3 </xsl:with-param>
                                    </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    
        <xsl:call-template name="msoif-close" />
    </xsl:template>
    
    <xsl:template name="messages">
        <xsl:param name="width">540</xsl:param>
    
        <xsl:if test="message/message">
            <xsl:call-template name="msoif-open">
                <xsl:with-param name="width" select="$width" />
            </xsl:call-template>
        
            <div style="max-width: {$width}px; margin: 0px auto">
                <table>
                    <xsl:call-template name="table-layout-attributes" />
                    <tbody>
                        <tr>
                            <td class="text">
                                <xsl:apply-templates select="message/message" mode="message"/>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <xsl:call-template name="msoif-close" />
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="message" mode="message">
        <p><xsl:value-of select="." disable-output-escaping="yes"/></p>
    </xsl:template>
    
    <xsl:template match="link" mode="button">
        <xsl:call-template name="button">
            <xsl:with-param name="url" select="url"/>
            <xsl:with-param name="text" select="text"/>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>