<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">


    <xsl:template match="details">
        <xsl:param name="width">540</xsl:param>
        <xsl:param name="margin-top">10</xsl:param>
        <xsl:param name="margin-bottom">20</xsl:param>
        <xsl:param name="padding-top">5</xsl:param>
        <xsl:param name="padding-bottom">25</xsl:param>
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    
                    <xsl:apply-templates select="title" mode="details"/>
                    
                   	<xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-top"/>
                    </xsl:call-template>
                    <tr>
                        <td>
                            <xsl:call-template name="block-style"/>
                                <table>
                                     <xsl:call-template name="table-layout-attributes" />
                                    <tbody>
                                        <xsl:call-template name="row-vertical-spacer">
                                            <xsl:with-param name="height" select="$padding-top"/>
                                            <xsl:with-param name="colspan">3</xsl:with-param>
                                        </xsl:call-template>
                                        <tr>
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width">0</xsl:with-param>
                                            </xsl:call-template>
                                            <td>
                                                <xsl:call-template name="td-layout-attributes" />
                                        
                                                <xsl:call-template name="msoif-open">
                                                    <xsl:with-param name="width" select="$width"/>
                                                </xsl:call-template>
                                                <div style="max-width: {$width}px; margin: 0px auto">
                                                  <table>
                                                    <xsl:call-template name="table-layout-attributes" />
                                                    <tbody>
                                                      <tr>
                                                        <td
                                                          style="
                                                            direction: ltr;
                                                            font-size: 0px;
                                                            padding: 0px;
                                                            word-break: break-word;
                                                            border-radius: 8px;
                                                            overflow: hidden;
                                                          "
                                                        >
                                                            <table>
                                                                <xsl:call-template name="table-layout-attributes" />
                                                                <tbody>
                                                                  <xsl:call-template name="row-vertical-spacer">
                                                                        <xsl:with-param name="height">0</xsl:with-param>
                                                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                                                  </xsl:call-template>
                                                                  <tr>
                                                                    <xsl:call-template name="row-horizontal-spacer">
                                                                        <xsl:with-param name="width" select="$padding-left"/>
                                                                    </xsl:call-template>
                                                                    <td align="left" class="text text2">
                                                                        <xsl:if test="technical = 'true'"><xsl:attribute name="class">text text2 monospace</xsl:attribute></xsl:if>
                                                                        <xsl:apply-templates select="text" mode="details"/>
                                                                    </td>
                                                                    <xsl:call-template name="row-horizontal-spacer">
                                                                        <xsl:with-param name="width" select="$padding-right"/>
                                                                    </xsl:call-template>
                                                                  </tr>
                                                                  <xsl:call-template name="row-vertical-spacer">
                                                                      <xsl:with-param name="height" select="$padding-bottom"/>
                                                                      <xsl:with-param name="colspan">3</xsl:with-param>
                                                                  </xsl:call-template>
                                                                </tbody>
                                                          </table>
                                                        </td>
                                                      </tr>
                                                    </tbody>
                                                  </table>
                                                </div>
                                                <xsl:call-template name="msoif-close"/>
                                            </td>
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width">0</xsl:with-param>
                                            </xsl:call-template>
                                        </tr>
                                        <xsl:call-template name="row-vertical-spacer">
                                            <xsl:with-param name="height">0</xsl:with-param>
                                            <xsl:with-param name="colspan">3</xsl:with-param>
                                        </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-bottom"/>
                    </xsl:call-template>
                </tbody>
            </table>
        </div>
    </xsl:template>

    <xsl:template match="text" mode="details">
        <p>
            <xsl:value-of select="." disable-output-escaping="yes"></xsl:value-of>
            
        </p>
    </xsl:template>
    
    <xsl:template match="title" mode="details">
        <tr>
            <td>
                <xsl:call-template name="subtitle-style"/>
                <xsl:value-of select="."/>
            </td>
        </tr>
    </xsl:template>
</xsl:stylesheet>