<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:template name="footer">
    <div style="max-width: 600px; margin: 0px auto;">
      <table>
        <xsl:call-template name="table-layout-attributes"/>
        
        <tbody>
          <xsl:call-template name="row-vertical-spacer">
            <xsl:with-param name="height">45</xsl:with-param>
          </xsl:call-template>
          
          <tr>
            <td
              align="center"
              style="
                direction: ltr;
                font-size: 0px;
                padding: 0px;
                word-break: break-word;
              "
            >
              
              <xsl:call-template name="footer-content"/>
              
              <xsl:call-template name="footer-bottom-logo"/>
              
              <xsl:apply-templates select="footer/additionalText" mode="footer-bottom-text"/>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    </xsl:template>
    
    <xsl:template name="footer-content">
      <xsl:call-template name="msoif-open"/>
      
      <div style="max-width: 600px; margin: 0px auto;">
        <table>
           <xsl:call-template name="table-layout-attributes"/>
           
          <tbody>
            <tr>
              <td>
                <xsl:call-template name="td-layout-attributes"/>
                
                <table>
                    <xsl:call-template name="table-layout-attributes"/>
                    
                  <tbody>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height">0</xsl:with-param>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>    
                    <tr>
                        <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width">0</xsl:with-param>
                        </xsl:call-template>  
                        <td>
                            <xsl:call-template name="td-center-layout-attributes"/>
                            
                            <xsl:call-template name="footer-inner-content"/>
                        </td>
                        <xsl:call-template name="row-horizontal-spacer">
                          <xsl:with-param name="width">0</xsl:with-param>
                        </xsl:call-template>  
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height">0</xsl:with-param>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>    
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <!--[if mso | IE]></td></tr></table><![endif]-->
    </xsl:template>
    
    <xsl:template name="footer-inner-content">
        <xsl:call-template name="footer-text-product"/>
                        
        <xsl:apply-templates select="footer/link" mode="footer-link"/>                
    </xsl:template>
    
    <xsl:template name="footer-text-product">
        <div>
            <xsl:call-template name="footer-style"/>
            <i18n:text i18n:key="PLUGINS_CORE_UI_MAIL_FOOTER_POWER_BY" i18n:catalogue="plugin.core-ui"/>
            <a href="http://www.ametys.org">
                <xsl:call-template name="footer-link-style"/>
                <xsl:call-template name="footer-text-product-name"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-text-product-name">
        <i18n:text i18n:key="PLUGINS_CORE_UI_MAIL_FOOTER_PRODUCT_NAME" i18n:catalogue="plugin.core-ui"/>
    </xsl:template>
    
    <xsl:template match="link" mode="footer-link">
        <xsl:call-template name="footer-link">
            <xsl:with-param name="url" select="url"/>
            <xsl:with-param name="text" select="text"/>
            <xsl:with-param name="isI18n">false</xsl:with-param>
            <xsl:with-param name="imgPluginName" select="imgPluginName"/>
            <xsl:with-param name="imgPath" select="imgPath"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="footer-link">
        <xsl:param name="margin-top">15</xsl:param>
        <xsl:param name="imgPath"/>
        <xsl:param name="imgPluginName"/>
        <xsl:param name="url"/>
        <xsl:param name="text"/>
        <xsl:param name="isI18n">true</xsl:param>
    
        <xsl:call-template name="table-vertical-spacer">
            <xsl:with-param name="height" select="$margin-top"/>
        </xsl:call-template>
        
        <table cellspacing="8">
          <tr>
            <xsl:if test="$imgPath">
                <td width="24">
                    <img
                        src="{ametys:pluginImageBase64($imgPluginName, $imgPath)}"
                        alt=""
                        width="16" height="16" valign="middle"
                      />
                </td>
            </xsl:if>
            <td>
              <a
                href="{$url}"
                style="
                  line-height: 22px;
                  font-size: 12px;
                  font-family: {$font-family};
                  font-weight: 500;
                  text-decoration: none;
                  color: {$text-color};">
                  <xsl:choose>
                    <xsl:when test="$isI18n = 'true'"><xsl:copy-of select="$text"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise>
                  </xsl:choose>
                  
              </a>
            </td>
          </tr>
        </table>
    </xsl:template>
    
    <xsl:template name="footer-bottom-logo">
      <xsl:param name="margin-top">15</xsl:param>
      <xsl:param name="margin-bottom">5</xsl:param>
      
      <xsl:call-template name="msoif-open"/>
      <div style="max-width: 600px; margin: 0px auto">
        <table>
            <xsl:call-template name="table-layout-attributes"/>
          <tbody>
            <tr>
              <td>
                 <xsl:call-template name="td-layout-attributes"/>
                 
                <table>
                    <xsl:call-template name="table-layout-attributes"/>
                    
                  <tbody>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-top"/>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                    <tr>
                          <xsl:call-template name="row-horizontal-spacer">
                             <xsl:with-param name="width">20</xsl:with-param>
                          </xsl:call-template>
                          <td>
                            <xsl:call-template name="td-center-layout-attributes"/>
                            
                            <!-- Logo + Link to site -->
                            <xsl:call-template name="footer-logo"/>
                          </td>
                          <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width">20</xsl:with-param>
                          </xsl:call-template>
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-bottom"/>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      
      <xsl:call-template name="msoif-close"/>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <xsl:call-template name="footer-logo-img"/>
    </xsl:template>
    
    <xsl:template name="footer-logo-img">
        <img
            width="113"
            height="56"
            src="{ametys:pluginImageBase64('core-ui', 'img/mail/logo-ametys.png')}"
            alt="Ametys"/>
    </xsl:template>
    
    <xsl:template match="additionalText" mode="footer-bottom-text">
      <xsl:param name="margin-top">25</xsl:param>
      <xsl:param name="margin-bottom">5</xsl:param>
      
      <xsl:call-template name="msoif-open"/>
      <div style="max-width: 600px; margin: 0px auto">
        <table>
            <xsl:call-template name="table-layout-attributes"/>
          <tbody>
            <tr>
              <td>
                 <xsl:call-template name="td-layout-attributes"/>
                 
                <table>
                    <xsl:call-template name="table-layout-attributes"/>
                    
                  <tbody>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-top"/>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                    <tr>
                          <xsl:call-template name="row-horizontal-spacer">
                             <xsl:with-param name="width">20</xsl:with-param>
                          </xsl:call-template>
                          <td>
                            <xsl:call-template name="td-center-layout-attributes"/>
                            <div>
                                <xsl:call-template name="footer-bottom-style"/>
                                <xsl:value-of select="." disable-output-escaping="yes"/>
                            </div>
                          </td>
                          <xsl:call-template name="row-horizontal-spacer">
                            <xsl:with-param name="width">20</xsl:with-param>
                          </xsl:call-template>
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-bottom"/>
                        <xsl:with-param name="colspan">3</xsl:with-param>
                    </xsl:call-template>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      
      <xsl:call-template name="msoif-close"/>
    </xsl:template>
    
</xsl:stylesheet>