<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="styles.xsl"/>
    
    <xsl:template name="head">
        <head>
            <xsl:call-template name="head-title"/>
            
            <xsl:text disable-output-escaping="yes">&lt;!-- [if !mso]&gt;&lt;! --&gt;</xsl:text>
            <meta http-equiv="X-UA-Compatible" content="IE=edge"></meta>
            <xsl:text disable-output-escaping="yes">&lt;!--&lt;![endif] --&gt;</xsl:text>
            
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"></meta>
            <meta name="viewport" content="width=device-width, initial-scale=1"></meta>
            <!--[if mso]>
              <noscript>
                <xml>
                  <o:OfficeDocumentSettings>
                    <o:AllowPNG />
                    <o:PixelsPerInch>96</o:PixelsPerInch>
                  </o:OfficeDocumentSettings>
                </xml>
              </noscript><!
            [endif]-->
            
            <xsl:text disable-output-escaping="yes">&lt;!--[if mso]> &lt;noscript> &lt;xml> &lt;o:OfficeDocumentSettings> &lt;o:AllowPNG 
                /> &lt;o:PixelsPerInch>96&lt;/o:PixelsPerInch> &lt;/o:OfficeDocumentSettings> &lt;/xml> 
                &lt;/noscript>&lt;![endif] --></xsl:text>
            
            <xsl:call-template name="styles"/>
            <xsl:call-template name="custom-styles"/>
         </head>
    </xsl:template>
    
    
    <xsl:template name="head-title">
        <!-- <title>Mailing Notification Breve - 1</title> -->
    </xsl:template>
</xsl:stylesheet>