<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:template name="header">
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width">630</xsl:with-param>
        </xsl:call-template>
    
        <div style="max-width: 630px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height">25</xsl:with-param>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                    <tr>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width">20</xsl:with-param>
                                        </xsl:call-template>
                                        <td>
                                            <xsl:call-template name="td-center-layout-attributes" />
                                            <!-- Logo -->
                                            <xsl:call-template name="header-logo" />
                                        </td>
                                        <xsl:call-template name="row-horizontal-spacer">
                                            <xsl:with-param name="width">20</xsl:with-param>
                                        </xsl:call-template>
                                    </tr>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height">25</xsl:with-param>
                                        <xsl:with-param name="colspan">3</xsl:with-param>
                                    </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <xsl:call-template name="msoif-close" />
    </xsl:template>
    
    <xsl:template name="header-logo">
        <xsl:call-template name="header-logo-img"/>
    </xsl:template>
    
    <xsl:template name="header-logo-img">
        <img
            width="113"
            height="56"
            src="{ametys:pluginImageBase64('core-ui', 'img/mail/logo-ametys.png')}"
            alt="Ametys"/>
    </xsl:template>
</xsl:stylesheet>