<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    
    <xsl:template name="table-layout-attributes">
        <xsl:attribute name="align">center</xsl:attribute>
        <xsl:attribute name="border">0</xsl:attribute>
        <xsl:attribute name="cellpadding">0</xsl:attribute>
        <xsl:attribute name="cellspacing">0</xsl:attribute>
        <xsl:attribute name="role">presentation</xsl:attribute>
        <xsl:attribute name="style">border-collapse: collapse; border-spacing: 0px; width: 100%</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="td-layout-attributes">
        <xsl:param name="bgcolor"/>
        <xsl:param name="vertical-align"/>
        
        <xsl:attribute name="style">direction: ltr;font-size: 0px;padding: 0px;word-break: break-word;<xsl:if test="$bgcolor != ''"> background-color: <xsl:value-of select="$bgcolor"/>;</xsl:if><xsl:if test="$vertical-align != ''"> vertical-align: <xsl:value-of select="$vertical-align"/>;</xsl:if></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="td-center-layout-attributes">
        <xsl:call-template name="td-layout-attributes"/>
        <xsl:attribute name="align">center</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="msoif-open">
        <xsl:param name="width">600</xsl:param>
        
        <xsl:text disable-output-escaping="yes">&lt;!--[if mso | IE]>&lt;table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" width="</xsl:text><xsl:value-of select="$width"/><xsl:text disable-output-escaping="yes">">&lt;tr>&lt;td style="line-height: 0px; font-size: 0px; mso-line-height-rule: exactly;">&lt;![endif]--></xsl:text>
    </xsl:template>
    
    <xsl:template name="msoif-close">
        <xsl:text disable-output-escaping="yes">&lt;!--[if mso | IE]>&lt;/td>&lt;/tr>&lt;/table>&lt;![endif]--></xsl:text>
    </xsl:template>
    
    <!-- Template to add vertical space (margin top or bottom) with a table layout -->
    <xsl:template name="table-vertical-spacer">
        <xsl:param name="height">5</xsl:param>
        
        <xsl:if test="$height != 0">
            <table>
              <xsl:call-template name="table-layout-attributes"/>
              <tbody>
                <xsl:call-template name="row-vertical-spacer">
                    <xsl:with-param name="height" select="$height"/>
                </xsl:call-template>
              </tbody>
            </table>
        </xsl:if>
    </xsl:template>
    
    <!-- Template to add vertical space (margin top or bottom) with a row table -->
    <xsl:template name="row-vertical-spacer">
        <xsl:param name="height">5</xsl:param>
        <xsl:param name="colspan">1</xsl:param>
        
        <xsl:if test="$height != 0">
            <tr>
                <td
                  height="{$height}"
                  colspan="{$colspan}">
                  <xsl:call-template name="td-layout-attributes"/>
                  <xsl:call-template name="placeholder"/>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>
    
    <!-- Template to add horizontal space (margin left or right) with a column table -->
    <xsl:template name="row-horizontal-spacer">
        <xsl:param name="width">5</xsl:param>
        <xsl:param name="bgcolor"/>
        
        <td
            width="{$width}">
            <xsl:call-template name="td-layout-attributes">
                <xsl:with-param name="bgcolor" select="$bgcolor"/>
            </xsl:call-template>
            <xsl:call-template name="placeholder"/>
        </td>
                              
    </xsl:template>
    
    <xsl:template name="placeholder">
        <img
          width="1"
          height="1"
          src="{ametys:pluginImageBase64('core-ui', 'img/mail/placeholder.png')}"
          alt=""/>
    </xsl:template>
    
</xsl:stylesheet>