<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:variable name="font-family">Tahoma, Arial, sans-serif</xsl:variable>
    <xsl:variable name="primary">#9575cd</xsl:variable>
    <xsl:variable name="primary-light">#f4f1fa</xsl:variable>
    <xsl:variable name="grey-light">#f9f9f9</xsl:variable>
    <xsl:variable name="grey-light2">#e5e5e5</xsl:variable>
    <xsl:variable name="link-color"><xsl:value-of select="$primary"/></xsl:variable>
    <xsl:variable name="btn-color"><xsl:value-of select="$primary"/></xsl:variable>
    <xsl:variable name="btn-text-color">#ffffff</xsl:variable>
    <xsl:variable name="btn-border-radius">4</xsl:variable>
    <xsl:variable name="text-color">#7f8182</xsl:variable>
    <xsl:variable name="text-color-dark">#313131</xsl:variable>
    <xsl:variable name="bg-color">#f7f8fa</xsl:variable>
    <xsl:variable name="content-bg-color">#ffffff</xsl:variable>
    <xsl:variable name="content-border-radius">8px</xsl:variable>
    <xsl:variable name="separator-color"><xsl:value-of select="$grey-light2"/></xsl:variable>
    <xsl:variable name="max-width">600</xsl:variable>
    
    <xsl:template name="title-style">
        <xsl:attribute name="style">line-height: 1.4; font-weight: 300; font-size: 22px; font-family: <xsl:value-of select="$font-family"/>; color: <xsl:value-of select="$primary"/>; font-weight: 400; text-align: center;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="subtitle-style">
        <xsl:attribute name="style">font-size: <xsl:value-of select="$text-color-dark"/>; font-family: <xsl:value-of select="$font-family"/>; font-size: 15px; font-weight: 700; line-height: 31px;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="text-style">
        <xsl:attribute name="style">font-weight: 400; line-height: 1.4; font-size: 14px; text-align: left; font-family: <xsl:value-of select="$font-family"/>; color: <xsl:value-of select="$text-color"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="user-input-style">
        <xsl:attribute name="style">padding-top:16px; padding-bottom: 16px; background-color: <xsl:value-of select="$primary-light"/>; border-left: 2px solid <xsl:value-of select="$primary"/>; width: 100%;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="button-style">
        <xsl:attribute name="style">display: inline-block; border-radius: <xsl:value-of select="$btn-border-radius"/>px; line-height: 22px;  font-size: 16px; font-family: <xsl:value-of select="$font-family"/>; font-weight: 700; text-decoration: none; color: <xsl:value-of select="$btn-text-color"/>; background-color: <xsl:value-of select="$btn-color"/>; padding: 14px 25px; border: 1px solid <xsl:value-of select="$btn-color"/>;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="block-style">
        <xsl:attribute name="style">background-color: <xsl:value-of select="$grey-light"/>; direction: ltr; padding: 0px; word-break: break-word; border-radius: 8px; overflow: hidden;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="footer-style">
        <xsl:attribute name="style">line-height: 1.4; font-size: 14px; font-family: <xsl:value-of select="$font-family"/>; color: <xsl:value-of select="$text-color"/>; font-weight: 700;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="footer-link-style">
        <xsl:attribute name="style">text-decoration: none; color: <xsl:value-of select="$text-color"/>;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="footer-bottom-style">
        <xsl:attribute name="style">font-family: <xsl:value-of select="$font-family"/>; font-style: italic; font-size: 11px; color: <xsl:value-of select="$text-color"/>;</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="styles">
        <style>
          #outlook a {
            padding: 0;
          }
    
          html {
            text-rendering: optimizeLegibility;
            -webkit-font-smoothing: antialiased;
          }
    
          body {
            margin: 0;
            padding: 0;
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
          }
    
          table,
          td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
          }
    
          img {
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            -ms-interpolation-mode: bicubic;
          }
    
          p {
            display: block;
            margin: 0;
          }
    
          .page-heading a {
            font-weight: 700;
            color: <xsl:value-of select="$link-color"/>;
            text-decoration: none;
          }
    
          img {
            font-size: 12px;
            font-family: <xsl:value-of select="$font-family"/>;
            font-weight: 400;
          }
    
          .text {
             padding-bottom: 8px;
             font-size: 15px;
             line-height: 31px; 
             color: <xsl:value-of select="$text-color"/>; 
             font-family: <xsl:value-of select="$font-family"/>;
          }
          
          .text strong {
            font-weight: normal;
            color: <xsl:value-of select="$text-color-dark"/>;
          }
    
          .text a {
            color: <xsl:value-of select="$link-color"/>;
            text-decoration: underline;
          }
    
          .text p {
            margin: 10px 0;
          }
          
          .text2 p {
            margin: 20px 0px;
          }
          
          .monospace {
            font-family: Courier New;
            line-height: 20px !important; 
          }
      </style>
    </xsl:template>
    
    <xsl:template name="custom-styles"/>
</xsl:stylesheet>