<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:param name="lang" select="$lang"/>
    
    <xsl:variable name="datetime-format" select="ametys:translate('plugin.core-ui:PLUGINS_CORE_UI_MAIL_DATETIME_FORMAT', $lang)"></xsl:variable>
    
    <xsl:template name="user-inputs">
        <xsl:param name="margin-top">30</xsl:param>
        <xsl:param name="margin-bottom">30</xsl:param>
        
        <xsl:for-each select="userInputsSections/userInputsSections|unauthenticatedUserInputsSections/unauthenticatedUserInputsSections">
            <xsl:call-template name="msoif-open"/>
            
            <div style="width: 100%;">
                <table>
                    <xsl:call-template name="table-layout-attributes" />
                    <tbody>
                        <tr>
                            <td>
                                <xsl:call-template name="td-layout-attributes" />
                                <table>
                                    <xsl:call-template name="table-layout-attributes" />
                                    <tbody>
                                        <xsl:call-template name="row-vertical-spacer">
                                            <xsl:with-param name="height" select="$margin-top"/>
                                            <xsl:with-param name="colspan">3</xsl:with-param>
                                        </xsl:call-template>
                                        
                                        <xsl:apply-templates select="userInputHeader" />
                                        
                                        <tr>
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width">1</xsl:with-param>
                                            </xsl:call-template>
                                            <td>
                                                <xsl:call-template name="td-layout-attributes" />
            
                                                <xsl:call-template name="user-inputs-items" />
                                            </td>
                                            <xsl:call-template name="row-horizontal-spacer">
                                                <xsl:with-param name="width" select="0" />
                                            </xsl:call-template>
                                        </tr>
                                        <xsl:call-template name="row-vertical-spacer">
                                            <xsl:with-param name="height" select="$margin-bottom"/>
                                            <xsl:with-param name="colspan">3</xsl:with-param>
                                        </xsl:call-template>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <xsl:call-template name="msoif-close"/>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="userInputHeader">
        <xsl:param name="margin-bottom">5</xsl:param>
        
        <tr>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">1</xsl:with-param>
            </xsl:call-template>
            <td>
                <xsl:call-template name="subtitle-style"/>
                
                <xsl:value-of select="." disable-output-escaping="yes"/>
            </td>
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width" select="0" />
            </xsl:call-template>
        </tr>
        <xsl:call-template name="row-vertical-spacer">
            <xsl:with-param name="height" select="$margin-bottom"/>
            <xsl:with-param name="colspan">3</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="user-inputs-items">
        <table width="100%">
            <tr>
                <td>
                    <xsl:apply-templates select="userInput/userInput|unauthenticatedUserInput/unauthenticatedUserInput" mode="item"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    
    <xsl:template match="userInput|unauthenticatedUserInput" mode="item">
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        
        <div>
            <xsl:call-template name="user-input-style"/>
            <table>
                <tr>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width" select="$padding-left"/>
                    </xsl:call-template>
                    
                    <!-- User avatar -->
                    <td>
                        <xsl:apply-templates select="." mode="image"/>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">16</xsl:with-param>
                    </xsl:call-template>
                    <td>
                        <table>
                            <tr>
                                <!-- User name -->
                                <td style="font-size: 13px; line-height: 16px; color: {$text-color-dark}; font-family: {$font-family}; font-weight: 700;">
                                    <xsl:apply-templates select="." mode="author"/>
                                </td>
                            </tr>
                            <tr>
                                <!-- Date -->
                                <td style="font-size: 13px; line-height: 16px; color: {$text-color-dark}; font-family: {$font-family}">
                                    <xsl:apply-templates select="." mode="date"/>
                                </td>
                            </tr>
                            <tr>
                                <!-- Description -->
                                <td style="font-size: 13px; line-height: 16px; color: {$text-color}; font-family: {$font-family}" >
                                   <xsl:apply-templates select="." mode="description"/>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width" select="$padding-right"/>
                    </xsl:call-template>
                </tr>
            </table>
        </div>
    </xsl:template>
    
    <xsl:template match="userInput" mode="image">
        <img width="38" height="38" src="{avatar:resolveAsBase64(author/login, author/populationId, 38, $lang)}" alt="{author/fullname}" style="display: block; border: solid 3px #fff; border-radius: 50%; outline: none; text-decoration: none;"/>
    </xsl:template>
    
    <xsl:template match="unauthenticatedUserInput" mode="image">
        <img width="38" height="38" src="{ametys:pluginImageBase64('core-ui', 'img/mail/avatar.png')}" alt="{authorName}" style="display: block; border: solid 3px #fff; border-radius: 50%; outline: none; text-decoration: none;"/>
    </xsl:template>
    
    <xsl:template match="userInput" mode="author">
        <xsl:value-of select="author/fullname"/>
    </xsl:template>
    
    <xsl:template match="unauthenticatedUserInput" mode="author">
        <xsl:value-of select="authorName"/>
    </xsl:template>
    
    <xsl:template match="userInput|unauthenticatedUserInput" mode="date">
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$datetime-format}" value="{date}"/>
    </xsl:template>
    
    <xsl:template match="userInput|unauthenticatedUserInput" mode="description">
        <xsl:value-of select="description" disable-output-escaping="yes"/>
    </xsl:template>
</xsl:stylesheet>