<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:import href="components/layout-elements.xsl"/>
    <xsl:import href="components/styles.xsl"/>
    <xsl:import href="components/head.xsl"/>
    <xsl:import href="components/header.xsl"/>
    <xsl:import href="components/footer.xsl"/>
    <xsl:import href="components/content.xsl"/>
    
    <xsl:param name="lang"/>
    
    <xsl:template match="/ActionResult">
        <html
          xmlns="http://www.w3.org/1999/xhtml"
          xmlns:v="urn:schemas-microsoft-com:vml"
          xmlns:o="urn:schemas-microsoft-com:office:office">
          
          <xsl:call-template name="head"/>
          
          <xsl:call-template name="body"/>
          
        </html>
    </xsl:template>
    
    <xsl:template name="body">
        <xsl:param name="margin-top">45</xsl:param>
        <xsl:param name="margin-bottom">60</xsl:param>
        <xsl:param name="width">630</xsl:param>
        
        <body style="word-spacing: normal; background-color: {$bg-color}">
            <xsl:call-template name="table-vertical-spacer">
                <xsl:with-param name="height" select="$margin-top"/>
            </xsl:call-template>
    
            <xsl:call-template name="msoif-open">
                <xsl:with-param name="width" select="$width"/>
            </xsl:call-template>
    
            <div style="max-width: {$width}px; margin: 0px auto">
              <table>
                <xsl:call-template name="table-layout-attributes"/>
                <tbody>
                  <tr>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">0</xsl:with-param>
                    </xsl:call-template>
                    
                    <xsl:call-template name="content"/>
                    
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">15</xsl:with-param>
                    </xsl:call-template>
                  </tr>
                </tbody>
              </table>
            </div>
            
            <xsl:call-template name="msoif-close"/>
    
            <xsl:call-template name="footer"/>
    
            <xsl:call-template name="table-vertical-spacer">
                <xsl:with-param name="height" select="$margin-bottom"/>
            </xsl:call-template>
        </body>
    </xsl:template>

</xsl:stylesheet>
