/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const RightManager = Java.type('org.ametys.core.right.RightManager');
const _rightProfileDAO = Ametys.serviceManager.lookup("org.ametys.core.right.RightProfilesDAO");
const _listUsersRight = "Runtime_Rights_ListUsers";

logger.info("Start adding 'List users' right to all profiles");

let count = 0;
let profiles=_rightProfileDAO.getProfiles()
for(let profile of profiles)
{
    if (profile.getId() != RightManager.READER_PROFILE_ID)
    {
        let profileRights = _rightProfileDAO.getRights(profile);
        if (!profileRights.contains(_listUsersRight))
        {
            _rightProfileDAO.addRight(profile, _listUsersRight);
            count++;
        }        
    }
    
}

logger.info(`${count} profile(s) have been updated`);
