/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

// Migration not needed if migration RUNTIME-3973 has been executed

// Create UserGlobalPreferences table in internal database
const ConnectionHelper = Java.type("org.ametys.core.datasource.ConnectionHelper");
const SQLDataSourceManager = Java.type("org.ametys.core.datasource.SQLDataSourceManager");
const SQLScriptHelper = Java.type("org.ametys.core.script.SQLScriptHelper");

let internalDataSource = SQLDataSourceManager.AMETYS_INTERNAL_DATASOURCE_ID;
// Get database's type
let connection = ConnectionHelper.getInternalSQLDataSourceConnection();
let dbType = ConnectionHelper.getDatabaseType(connection);

// If table already exist in internal database, do nothing
if (SQLScriptHelper.tableExists(connection , "UserGlobalPreferences"))
{
    return;
}

// Create UserGlobalPreferences database
let creationQuery;

switch(dbType)
{
    case 'derby':
        creationQuery = "CREATE TABLE \"UserGlobalPreferences\"(login varchar(64) NOT NULL, population varchar(200) NOT NULL, pref_profile_image BLOB, pref_timezone varchar(128), pref_language varchar(64), PRIMARY KEY(login, population))";
         break;
    case 'hsqldb':
        creationQuery = "CREATE CACHED TABLE \"UserGlobalPreferences\" (login varchar(64) NOT NULL,population varchar(200) NOT NULL, pref_profile_image BLOB, pref_timezone varchar(128), pref_language varchar(64), PRIMARY KEY(login, population));";
        break;
    case 'oracle':
        creationQuery = "CREATE TABLE \"UserGlobalPreferences\"(login varchar(64) NOT NULL, population varchar(200) NOT NULL, pref_profile_image BLOB, pref_timezone varchar(128), pref_language varchar(64), PRIMARY KEY(login, population));";
        break;
    case 'postgresql':
        creationQuery = "CREATE TABLE \"UserGlobalPreferences\"(login varchar(64) NOT NULL, population varchar(200) NOT NULL, pref_profile_image bytea, pref_timezone varchar(128), pref_language varchar(64), PRIMARY KEY(login, population)); COMMIT;"
        break;
    case 'mysql':
        creationQuery = "CREATE TABLE IF NOT EXISTS `UserGlobalPreferences`(login varchar(64) BINARY NOT NULL, population varchar(200) BINARY NOT NULL, pref_profile_image LONGBLOB, pref_timezone varchar(128), pref_language varchar(64), PRIMARY KEY(login, population)) ENGINE=innodb CHARACTER SET utf8;";
        break;
}

// Create user global preferences table
SQL.update(creationQuery, internalDataSource);

ConnectionHelper.cleanup(connection);
