/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

// Migrate CleanCacheSchedulable jobs to new params.

const Scheduler = Java.type("org.ametys.plugins.core.schedule.Scheduler");
const I18nizableText = Java.type("org.ametys.runtime.i18n.I18nizableText");

const _scheduler = Ametys.serviceManager.lookup(Scheduler.ROLE);
const _userHelper = Ametys.serviceManager.lookup(org.ametys.plugins.core.user.UserHelper.ROLE);
const _i18nUtils = Ametys.serviceManager.lookup(org.ametys.core.util.I18nUtils.ROLE);

let migratedCounter = 0;

let jobKeys = _scheduler.getJobs();
jobKeys.forEach(jobKey => {
    // Retrieve the job details based on job key
    let jobDetail = _scheduler.getScheduler().getJobDetail(jobKey);
    if (jobDetail != null) {
        let jobDataMap = jobDetail.getJobDataMap();
        
        // Retrieve the schedulable to check if the job needs to be migrated
        let schedulableId = jobDataMap.getString(Scheduler.KEY_SCHEDULABLE_ID);
        if (schedulableId == "org.ametys.core.cache.CleanCacheSchedulable") {
            // Check if the job has an old params
            let cacheIdParam = jobDataMap.getString(Scheduler.PARAM_VALUES_PREFIX + "cacheId");
            if (cacheIdParam != null) {
                // The job needs to be migrated
                let id = jobKey.getName();
                logger.debug(`Migrating params for job ${id}`);
                
                // get the required param for edition
                let label = _i18nUtils.translate(I18nizableText.stringToI18nizableText(jobDataMap.get(Scheduler.KEY_RUNNABLE_LABEL)));
                let description = _i18nUtils.translate(I18nizableText.stringToI18nizableText(jobDataMap.get(Scheduler.KEY_RUNNABLE_DESCRIPTION)));
                let fireProcess = jobDataMap.getString(Scheduler.KEY_RUNNABLE_FIRE_PROCESS);
                let cron = jobDataMap.getString(Scheduler.KEY_RUNNABLE_CRON);
                let launchUser = _userHelper.user2json(org.ametys.core.user.UserIdentity.stringToUserIdentity(jobDataMap.getString(Scheduler.KEY_RUNNABLE_USERIDENTITY)));
                // build the new params, we store the old param in a new array in the right parameter and set allCaches to false
                let params = { 'org.ametys.core.cache.CleanCacheSchedulable$cacheIds': [cacheIdParam]};
                _scheduler.edit(id, label, description, fireProcess, cron, launchUser, params);
                migratedCounter++;
            }
        }
    }
});
logger.info(`${migratedCounter} jobs were migrated successfully.`);
