/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

Ext.define("Ametys.message.ProfileMessageTarget", {
    override: "Ametys.message.MessageTarget",

     statics: 
     {
         /**
          * @member Ametys.message.MessageTarget
          * @readonly
          * @property {String} PROFILE The target type is a profile. The expected parameters are:
          * @property {String} PROFILE.id The id of profile
          * @property {String} [PROFILE.name] The name of the profile
          * @property {String} [PROFILE.context] the context of the profile
          * @property {Boolean} [PROFILE.modifiable=true] is the profile modifiable?
          */
         PROFILE: "profile",
         
         /**
          * @member Ametys.message.MessageTarget
          * @readonly
          * @property {String} RIGHT The target type is a rigth. The expected parameters are:
          * @property {String} RIGHT.id The id of right
          */
         RIGHT: "right"
     }
});
