<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:math="http://exslt.org/math"
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
                exclude-result-prefixes="math captcha">
    
    <xsl:import href="captcha://helper.xsl"/>
    
    <xsl:variable name="captcha-plugin">core-impl</xsl:variable>
    
    <xsl:template name="captcha">
        <xsl:param name="key-name">captcha-key</xsl:param>
        <xsl:param name="key-id" select="concat('id', substring-after(math:random(), '.'))"/>

        <xsl:param name="color">#000000</xsl:param>
        
        <xsl:param name="value-name">captcha-value</xsl:param>
        <xsl:param name="value-id" select="concat('id', substring-after(math:random(), '.'))"/>
        <xsl:param name="value-style"/>
        <xsl:param name="value-class"/>
        
        <xsl:param name="placeholder"/>
        <xsl:param name="placeholder-i18n"/>
        <xsl:param name="placeholder-catalogue"/>
        
        <xsl:param name="image-id" select="concat('id', substring-after(math:random(), '.'))"/>
        <xsl:param name="image-alt"/>
        <xsl:param name="image-alt-i18n" select="false()"/>
        <xsl:param name="image-alt-catalogue"/>
        <xsl:param name="image-style"/>
        <xsl:param name="image-class"/>
        <xsl:param name="image-width">200</xsl:param>
        <xsl:param name="image-height">50</xsl:param>
        
        <xsl:param name="recaptcha-theme">light</xsl:param>
        <xsl:param name="recaptcha-size">normal</xsl:param>
        
        <xsl:param name="allow-refresh" select="true()"/>
        
        <xsl:param name="js-funcname-torefresh" select="concat('refresh_captcha_', substring-after(math:random(), '.'))"/>

        <xsl:param name="plugin" select="$captcha-plugin"/>
        
        <xsl:param name="aria-invalid"/>
        <xsl:param name="aria-describedby"/>
        
        <xsl:call-template name="captcha_impl">
            <xsl:with-param name="key-name" select="$key-name"/>
            <xsl:with-param name="key-id" select="$key-id"/>
            <xsl:with-param name="color" select="$color"/>
            <xsl:with-param name="value-name" select="$value-name"/>
            <xsl:with-param name="value-id" select="$value-id"/>
            <xsl:with-param name="value-style" select="$value-style"/>
            <xsl:with-param name="value-class" select="$value-class"/>
            <xsl:with-param name="placeholder" select="$placeholder"/>
            <xsl:with-param name="placeholder-i18n" select="$placeholder-i18n"/>
            <xsl:with-param name="placeholder-catalogue" select="$placeholder-catalogue"/>
            <xsl:with-param name="image-id" select="$image-id"/>
            <xsl:with-param name="image-alt" select="$image-alt"/>
            <xsl:with-param name="image-alt-i18n" select="$image-alt-i18n"/>
            <xsl:with-param name="image-alt-catalogue" select="$image-alt-catalogue"/>
            <xsl:with-param name="image-style" select="$image-style"/>
            <xsl:with-param name="image-class" select="$image-class"/>
            <xsl:with-param name="image-width" select="$image-width"/>
            <xsl:with-param name="image-height" select="$image-height"/>
            <xsl:with-param name="allow-refresh" select="$allow-refresh"/>
            <xsl:with-param name="js-funcname-torefresh" select="$js-funcname-torefresh"/>
            <xsl:with-param name="plugin" select="$plugin"/>
            <xsl:with-param name="recaptcha-theme" select="$recaptcha-theme"/>
            <xsl:with-param name="recaptcha-size" select="$recaptcha-size"/>
            <xsl:with-param name="aria-invalid" select="$aria-invalid"/>
            <xsl:with-param name="aria-describedby" select="$aria-describedby"/>
        </xsl:call-template>
            
    </xsl:template>

</xsl:stylesheet>
