<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:func="http://exslt.org/functions"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
                xmlns:javazoneddatetime="java.time.ZonedDateTime"
                xmlns:javalocaldate="java.time.LocalDate"
                xmlns:javalocaldatetime="java.time.LocalDateTime"
                xmlns:javazoneid="java.time.ZoneId"
                extension-element-prefixes="func dateutils">
    
    <xsl:variable name="icalDateTimePattern">uuuuMMdd'T'HHmmss'Z'</xsl:variable>
    
    <func:function name="datetime:sameDate">
        <!-- pattern should be "yyyy-MM-dd'T'HH:mm:ss" or "yyyy-MM-dd'T'HH:mm:ss+01:00" or "yyyy-MM-dd'T'HH:mm:ss+01:00[Europe/Paris]" -->
        <xsl:param name="dateTime1"/> <!-- as string -->
        <xsl:param name="dateTime2"/> <!-- as string -->
        
        <xsl:variable name="localDate1" select="javazoneddatetime:toLocalDate(dateutils:parseZonedDateTime($dateTime1))"/>
        <xsl:variable name="localDate2" select="javazoneddatetime:toLocalDate(dateutils:parseZonedDateTime($dateTime2))"/>
        
        <func:result select="javalocaldate:isEqual($localDate1, $localDate2)"/>
    </func:function>
    
    <func:function name="datetime:sameDateTime">
        <!-- pattern should be "yyyy-MM-dd'T'HH:mm:ss" or "yyyy-MM-dd'T'HH:mm:ss+01:00" or "yyyy-MM-dd'T'HH:mm:ss+01:00[Europe/Paris]" -->
        <xsl:param name="dateTime1"/> <!-- as string -->
        <xsl:param name="dateTime2"/> <!-- as string -->
        
        <xsl:variable name="localDateTime1" select="javazoneddatetime:toLocalDateTime(dateutils:parseZonedDateTime($dateTime1))"/>
        <xsl:variable name="localDateTime2" select="javazoneddatetime:toLocalDateTime(dateutils:parseZonedDateTime($dateTime2))"/>
        
        <func:result select="javalocaldatetime:isEqual($localDateTime1, $localDateTime2)"/>
    </func:function>
    
    
    <func:function name="datetime:icalFormat">
        <xsl:param name="datetime"/><!-- to format yyyy-MM-dd'T'HH:mm:ss.SSSXXX -->
        
        <!-- format it in UTC ('Z') zone with the given pattern compliant to iCal format -->
        <func:result><xsl:value-of select="dateutils:zonedDateTimeToString(dateutils:parseZonedDateTime($datetime), javazoneid:of('UTC'), $icalDateTimePattern)"/></func:result>
    </func:function>
</xsl:stylesheet>
