/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.response.SolrQueryResponse;

public class CreateConfigSetAdminOp
implements CoreAdminHandler.CoreAdminOp {
    private static final String __CONFIGSET_TEMPLATE_NAME = "ametys-standard";

    public void execute(CoreAdminHandler.CallInfo info) throws Exception {
        SolrParams params = info.req.getParams();
        String name = params.get("name");
        if (name == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The createConfiset action must have the parameter 'name'");
        }
        this._createConfigSet(name, info.rsp, info.handler.getCoreContainer());
    }

    private void _createConfigSet(String name, SolrQueryResponse rsp, CoreContainer coreContainer) throws IOException {
        String solrHome = coreContainer.getSolrHome();
        File solrHomeDir = new File(solrHome);
        File configsetsDir = new File(solrHomeDir, "configsets");
        if (Files.notExists(Paths.get(coreContainer.getSolrHome(), "configsets", name), new LinkOption[0])) {
            FileUtils.copyDirectory((File)new File(configsetsDir, __CONFIGSET_TEMPLATE_NAME), (File)new File(configsetsDir, name));
            rsp.add("result", (Object)"created");
        } else {
            rsp.add("result", (Object)"already-exists");
        }
    }
}

