/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ametys.solr.helper.AclCacheManager;
import org.ametys.solr.helper.AmetysIOException;
import org.ametys.solr.helper.CoreHelper;
import org.ametys.solr.helper.DebugMessageHelper;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadAclCacheHandler
extends RequestHandlerBase {
    private static Logger __logger = LoggerFactory.getLogger(ReloadAclCacheHandler.class);
    private static final ConcurrentMap<String, Lock> __LOCKS_BY_CORE = new ConcurrentHashMap<String, Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        boolean isAmetysReachable;
        long start = System.currentTimeMillis();
        SolrCore core = req.getCore();
        String coreName = core.getName();
        SolrIndexSearcher searcher = req.getSearcher();
        String ametysUrl = CoreHelper.getAmetysUrl(core);
        SolrParams params = req.getParams();
        if ("firstSearcher".equals(params.get("event")) && !(isAmetysReachable = this._isAmetysReachable(ametysUrl))) {
            return;
        }
        ArrayList<IndexReader.CacheKey> segmentsToFill = null;
        if ("true".equals(params.get("checkIfNecessary"))) {
            segmentsToFill = new ArrayList<IndexReader.CacheKey>();
            List leaves = searcher.getTopReaderContext().leaves();
            for (LeafReaderContext context : leaves) {
                LeafReader reader = context.reader();
                IndexReader.CacheKey segmentKey = reader.getCoreCacheHelper().getKey();
                if (AclCacheManager.getAllowedUsersInCache(searcher, segmentKey) != null) continue;
                segmentsToFill.add(segmentKey);
            }
        }
        Lock lock = ReloadAclCacheHandler.getLock(coreName);
        lock.lock();
        try {
            this._invalidate(coreName, searcher, segmentsToFill == null);
            this._fill(coreName, searcher, segmentsToFill, ametysUrl);
            this._invalidateSolrCaches(coreName, searcher);
        }
        catch (AmetysIOException e) {
            __logger.error("An error occured when communicating with Ametys application. The ACL cache could not be reloaded correctly. All contents will be marked as not allowed.", (Throwable)e);
            AclCacheManager.putNoAllowedUserInCache(searcher);
            rsp.add("error", (Object)"communication-with-Ametys-application");
            return;
        }
        finally {
            lock.unlock();
        }
        rsp.add("result", (Object)"ok");
        __logger.debug("ReloadAclCacheHandler processed in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private boolean _isAmetysReachable(String ametysUrl) {
        try {
            HttpGet get = new HttpGet(ametysUrl);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpClientContext context = HttpClientContext.create();
            int timeout = 15000;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
            context.setRequestConfig(config);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get, (HttpContext)context);
            if (response.getStatusLine().getStatusCode() == 200) {
                __logger.info("URL {} is reachable. ACL cache will be auto-warmed up", (Object)ametysUrl);
                return true;
            }
            __logger.info("URL {} is unreachable. ACL cache will not be auto-warmed up", (Object)ametysUrl);
            return false;
        }
        catch (IOException e) {
            __logger.info("URL {} is unreachable. ACL cache will not be auto-warmed up", (Object)ametysUrl);
            return false;
        }
    }

    private void _invalidate(String coreName, SolrIndexSearcher searcher, boolean clearAclCache) {
        this._invalidateSolrCaches(coreName, searcher);
        SolrCache aclCache = searcher.getCache("aclCache");
        if (clearAclCache && aclCache != null) {
            aclCache.clear();
            __logger.debug("ACL Cache for core '{}' was cleared !", (Object)coreName);
        }
    }

    private void _invalidateSolrCaches(String coreName, SolrIndexSearcher searcher) {
        SolrInfoBean queryResultCache = (SolrInfoBean)searcher.getCore().getInfoRegistry().get("queryResultCache");
        if (queryResultCache != null && queryResultCache instanceof SolrCache) {
            ((SolrCache)queryResultCache).clear();
            __logger.debug("queryResultCache for core '{}' was cleared !", (Object)coreName);
        }
    }

    protected static Lock getLock(String coreName) {
        Lock lock = __LOCKS_BY_CORE.computeIfAbsent(coreName, n -> new ReentrantLock());
        return lock;
    }

    private void _fill(String coreName, SolrIndexSearcher searcher, List<IndexReader.CacheKey> segmentsToFill, String ametysUrl) throws AmetysIOException, IOException {
        __logger.debug("Try to fill ACL cache for core '{}' and several users", (Object)coreName);
        List leaves = searcher.getTopReaderContext().leaves();
        for (LeafReaderContext context : leaves) {
            LeafReader reader = context.reader();
            IndexReader.CacheKey segmentKey = reader.getCoreCacheHelper().getKey();
            if (segmentsToFill != null && !segmentsToFill.contains(segmentKey)) continue;
            String segmentName = DebugMessageHelper.segmentNameFromReader(reader, __logger);
            __logger.debug("Begin filling ACL cache for core '{}' and segment '{}'", (Object)coreName, (Object)segmentName);
            this._fillCacheForSegment(searcher, segmentKey, reader, ametysUrl, coreName);
            __logger.debug("End filling ACL cache for core '{}' and segment '{}'", (Object)coreName, (Object)segmentName);
        }
        __logger.debug("End filling ACL cache for core '{}' and several users", (Object)coreName);
    }

    public String getDescription() {
        return "Reload ACL Cache";
    }

    private void _fillCacheForSegment(SolrIndexSearcher searcher, IndexReader.CacheKey segmentKey, LeafReader reader, String ametysUrl, String coreName) throws AmetysIOException, IOException {
        AclCacheManager.computeAllowedUsers(reader, searcher, segmentKey, ametysUrl, coreName);
    }

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }
}

