/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.solr.handler;

import org.ametys.solr.core.AmetysCorePropertiesLocator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class UpdateCorePropertyHandler
extends RequestHandlerBase {
    private static AmetysCorePropertiesLocator _coresLocator;

    private static synchronized AmetysCorePropertiesLocator _getCoresLocator(CoreContainer coreContainer) {
        if (_coresLocator == null) {
            _coresLocator = new AmetysCorePropertiesLocator(coreContainer.getCoreRootDirectory());
        }
        return _coresLocator;
    }

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrCore core = req.getCore();
        CoreContainer cc = core.getCoreContainer();
        CoreDescriptor cd = core.getCoreDescriptor();
        SolrParams params = req.getParams();
        String propertyKey = params.get("key");
        if (propertyKey == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The /updateCoreProperty request handler must have the parameter 'key'");
        }
        if (CoreDescriptor.standardPropNames.contains(propertyKey)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The '" + propertyKey + "' property cannot be updated as it is a standard property.");
        }
        if (!cd.getPersistableUserProperties().containsKey(propertyKey)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The '" + propertyKey + "' property is an undefined property.");
        }
        String newPropertyValue = params.get("value");
        if (newPropertyValue == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The /updateCoreProperty request handler must have the parameter 'value'");
        }
        boolean valueChanged = UpdateCorePropertyHandler._getCoresLocator(cc).changePropertyValue(cc, cd, propertyKey, newPropertyValue);
        rsp.add("result", (Object)"ok");
        rsp.add("valueChanged", (Object)valueChanged);
    }

    public String getDescription() {
        return "Update property value of a core";
    }

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.CORE_EDIT_PERM;
    }
}

